/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.context;

import cn.is4j.insp.core.context.InspContext;
import cn.is4j.insp.core.context.InspContextHolderStrategy;
import cn.is4j.insp.core.context.InspContextImpl;

public class ThreadLocalInspContextHolderStrategy
implements InspContextHolderStrategy {
    private static final ThreadLocal<InspContext> CONTEXT_HOLDER = new InheritableThreadLocal<InspContext>();

    @Override
    public void clearContext() {
        CONTEXT_HOLDER.remove();
    }

    @Override
    public InspContext getContext() {
        InspContext ctx = CONTEXT_HOLDER.get();
        if (ctx == null) {
            ctx = this.createEmptyContext();
            CONTEXT_HOLDER.set(ctx);
        }
        return ctx;
    }

    @Override
    public void setContext(InspContext context) {
        if (null == context) {
            throw new IllegalArgumentException("Only non-null InspContext instances are permitted");
        }
        CONTEXT_HOLDER.set(context);
    }

    @Override
    public InspContext createEmptyContext() {
        return new InspContextImpl();
    }
}

