/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.intercept.aopalliance;

import cn.is4j.insp.core.annotation.Insp;
import cn.is4j.insp.core.context.InspContextHolder;
import cn.is4j.insp.core.exception.InspException;
import cn.is4j.insp.core.exception.InspExceptionTranslator;
import cn.is4j.insp.core.exception.ThrowableInsExceptionTranslator;
import cn.is4j.insp.core.exception.UnAuthenticationInspException;
import cn.is4j.insp.core.expression.DefaultMethodInspExpressionHandler;
import cn.is4j.insp.core.expression.InspExpressionHandler;
import cn.is4j.insp.core.expression.InspExpressionInvocationHandler;
import cn.is4j.insp.core.expression.InspExpressionOperations;
import cn.is4j.insp.core.expression.InspExpressionRoot;
import cn.is4j.insp.core.expression.InspMetadataSource;
import cn.is4j.insp.core.expression.method.MethodInspEvaluationContext;
import cn.is4j.insp.core.intercept.aopalliance.InspInterceptor;
import cn.is4j.insp.core.service.InspAuthentication;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.StringUtils;

public abstract class AbstractInspInterceptor
implements InspInterceptor,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private InspExceptionTranslator exceptionTranslator;
    private InspExpressionHandler expressionHandler = new DefaultMethodInspExpressionHandler();
    private BeanResolver br;

    public AbstractInspInterceptor() {
        this.exceptionTranslator = new ThrowableInsExceptionTranslator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object proceed(MethodInvocation invocation) throws Throwable {
        Object result;
        try {
            List<InspMetadataSource> metadataSources = this.obtainMetadataSource(invocation);
            for (InspMetadataSource metadataSource : metadataSources) {
                if (!StringUtils.hasText((String)metadataSource.getExpressionString())) continue;
                MethodInspEvaluationContext ctx = (MethodInspEvaluationContext)this.expressionHandler.createEvaluationContext(invocation);
                InspExpressionOperations expressionOperations = (InspExpressionOperations)Proxy.newProxyInstance(InspExpressionRoot.class.getClassLoader(), InspExpressionRoot.class.getInterfaces(), (InvocationHandler)new InspExpressionInvocationHandler(new InspExpressionRoot(), this, metadataSource));
                ctx.setRootObject(expressionOperations);
                ctx.setBeanResolver(this.br);
                Boolean expressionValue = (Boolean)this.expressionHandler.getExpressionParser().parseExpression(metadataSource.getExpressionString()).getValue((EvaluationContext)ctx, Boolean.class);
                if (null != expressionValue && expressionValue.booleanValue()) continue;
                throw new UnAuthenticationInspException("deny of access", metadataSource);
            }
        }
        catch (Exception e) {
            InspContextHolder.clearContext();
            if (e instanceof InspException) {
                this.exceptionTranslator.translate((InspException)e);
                return null;
            }
            throw e;
        }
        try {
            result = invocation.proceed();
        }
        finally {
            InspContextHolder.clearContext();
        }
        return result;
    }

    protected List<InspMetadataSource> obtainMetadataSource(MethodInvocation invocation) {
        Insp onClass = (Insp)AnnotationUtils.findAnnotation(invocation.getMethod().getDeclaringClass(), Insp.class);
        Insp onMethod = (Insp)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Insp.class);
        ArrayList<InspMetadataSource> metadataSources = new ArrayList<InspMetadataSource>();
        if (onClass != null) {
            metadataSources.add(new InspMetadataSource(onClass.groupName(), onClass.value()));
        }
        if (onMethod != null) {
            metadataSources.add(new InspMetadataSource(onMethod.groupName(), onMethod.value()));
        }
        return metadataSources;
    }

    @Override
    public InspAuthentication onAuthentication(InspMetadataSource metadataSource) {
        InspAuthentication authentication = InspContextHolder.getContext().getAuthentication(metadataSource.getGroupName());
        if (null == authentication) {
            authentication = this.loadAuthentication(metadataSource);
            InspContextHolder.getContext().setAuthentication(metadataSource.getGroupName(), authentication);
        }
        return authentication;
    }

    protected abstract InspAuthentication loadAuthentication(InspMetadataSource var1);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.br = new BeanFactoryResolver((BeanFactory)applicationContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setExceptionTranslator(InspExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setExpressionHandler(InspExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }
}

