/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.intercept.aopalliance;

import cn.is4j.insp.core.annotation.Insp;
import cn.is4j.insp.core.context.InspContextHolder;
import cn.is4j.insp.core.exception.InspException;
import cn.is4j.insp.core.exception.InspExceptionTranslator;
import cn.is4j.insp.core.exception.ThrowableInsExceptionTranslator;
import cn.is4j.insp.core.exception.UnAuthenticationInspException;
import cn.is4j.insp.core.expression.DefaultMethodInspExpressionHandler;
import cn.is4j.insp.core.expression.InspExpressionHandler;
import cn.is4j.insp.core.expression.MethodInspInterceptorMetadataSource;
import cn.is4j.insp.core.service.InspAuthentication;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.StringUtils;

public abstract class AbstractInspInterceptor {
    private InspExpressionHandler<MethodInvocation> expressionHandler = new DefaultMethodInspExpressionHandler();
    private final InspExceptionTranslator exceptionTranslator;

    public AbstractInspInterceptor() {
        this.exceptionTranslator = new ThrowableInsExceptionTranslator();
    }

    public AbstractInspInterceptor(InspExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object proceed(MethodInvocation invocation) throws Throwable {
        Object result;
        try {
            List<MethodInspInterceptorMetadataSource> metadataSources = this.obtainMetadataSource(invocation);
            for (MethodInspInterceptorMetadataSource metadataSource : metadataSources) {
                if (!StringUtils.hasText((String)metadataSource.getExpressionString())) continue;
                EvaluationContext ctx = this.expressionHandler.createEvaluationContext(metadataSource.getAuthentication(), metadataSource.getInvocation());
                Boolean expressionValue = (Boolean)this.expressionHandler.getExpressionParser().parseExpression(metadataSource.getExpressionString()).getValue(ctx, Boolean.class);
                if (null != expressionValue && expressionValue.booleanValue()) continue;
                throw new UnAuthenticationInspException("deny of access");
            }
        }
        catch (Exception e) {
            InspContextHolder.clearContext();
            if (e instanceof InspException) {
                this.exceptionTranslator.translate((InspException)e);
                return null;
            }
            throw e;
        }
        try {
            result = invocation.proceed();
        }
        finally {
            InspContextHolder.clearContext();
        }
        return result;
    }

    protected List<MethodInspInterceptorMetadataSource> obtainMetadataSource(MethodInvocation invocation) {
        Insp onClass = (Insp)AnnotationUtils.findAnnotation(invocation.getMethod().getDeclaringClass(), Insp.class);
        Insp onMethod = (Insp)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Insp.class);
        ArrayList<MethodInspInterceptorMetadataSource> metadataSources = new ArrayList<MethodInspInterceptorMetadataSource>();
        if (onClass != null) {
            metadataSources.add(new MethodInspInterceptorMetadataSource(invocation, this.loadAuthenticationCtx(onClass.groupName()), onClass.value()));
        }
        if (onMethod != null) {
            metadataSources.add(new MethodInspInterceptorMetadataSource(invocation, this.loadAuthenticationCtx(onMethod.groupName()), onMethod.value()));
        }
        return metadataSources;
    }

    private InspAuthentication loadAuthenticationCtx(String groupName) {
        InspAuthentication authentication = InspContextHolder.getContext().getAuthentication(groupName);
        if (null == authentication) {
            authentication = this.loadAuthentication(groupName);
            InspContextHolder.getContext().setAuthentication(groupName, authentication);
        }
        return authentication;
    }

    protected abstract InspAuthentication loadAuthentication(String var1);

    public void setExpressionHandler(InspExpressionHandler<MethodInvocation> expressionHandler) {
        this.expressionHandler = expressionHandler;
    }
}

