/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.expression;

import cn.is4j.insp.core.expression.InspExpressionOperations;
import cn.is4j.insp.core.service.InspAuthentication;

public class InspExpressionRoot
implements InspExpressionOperations {
    private final InspAuthentication authentication;

    public InspExpressionRoot(InspAuthentication authentication) {
        if (authentication == null) {
            throw new IllegalArgumentException("Authentication object cannot be null");
        }
        this.authentication = authentication;
    }

    @Override
    public boolean hasFunc(String funcAuthority) {
        return this.hasAnyFunc(funcAuthority);
    }

    @Override
    public boolean hasFuncData(String funcAuthority, String dataAuthority) {
        return this.hasFunc(funcAuthority) && this.hasData(dataAuthority);
    }

    @Override
    public boolean hasAnyFunc(String ... funcAuthority) {
        if (this.authentication.isHighestAuth()) {
            return true;
        }
        for (String s : funcAuthority) {
            if (!this.authentication.getFuncAuthorities().contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasData(String dataAuthority) {
        return this.hasAnyData(dataAuthority);
    }

    @Override
    public boolean hasAnyData(String ... dataAuthority) {
        if (this.authentication.isHighestAuth()) {
            return true;
        }
        for (String s : dataAuthority) {
            if (!this.authentication.getDataAuthorities().contains(s)) continue;
            return true;
        }
        return false;
    }
}

