/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.context;

import cn.is4j.insp.core.context.InspContext;
import cn.is4j.insp.core.context.InspContextHolderStrategy;
import cn.is4j.insp.core.context.InspContextImpl;
import org.springframework.util.Assert;

public class ThreadLocalInspContextHolderStrategy
implements InspContextHolderStrategy {
    private static final ThreadLocal<InspContext> contextHolder = new ThreadLocal();

    @Override
    public void clearContext() {
        contextHolder.remove();
    }

    @Override
    public InspContext getContext() {
        InspContext ctx = contextHolder.get();
        if (ctx == null) {
            ctx = this.createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    @Override
    public void setContext(InspContext context) {
        Assert.notNull((Object)context, (String)"Only non-null InspContext instances are permitted");
        contextHolder.set(context);
    }

    @Override
    public InspContext createEmptyContext() {
        return new InspContextImpl();
    }
}

