package cn.ironblog.util;

import cn.ironblog.common.DownloadResponseBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author WangNing
 **/

public class Utils {

    private static final Pattern M3U8URLPattern = Pattern.compile(".*\\.ts",Pattern.MULTILINE);

    public static List<String> getVideoList(URL parentURL, String m3u8)  {

        List<String> list = new ArrayList<>();
        Matcher matcher = M3U8URLPattern.matcher(m3u8);
        while (matcher.find()){
            String abURL = matcher.group();
            try{
                URL url = new URL(parentURL, abURL);
                list.add(url.toString());
            }catch (Exception ignored){

            }

        }
        return list;

    }

    public static OkHttpClient getClient(Proxy proxy, AtomicLong downloadLength){

        // 重写ResponseBody监听请求
        Interceptor interceptor = new Interceptor() {
            @Override
            public Response intercept(Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder()
                        .body(new DownloadResponseBody(originalResponse, downloadLength))
                        .build();
            }
        };

        X509TrustManager manager = SSLSocketClientUtil.getX509TrustManager();
        OkHttpClient client = new OkHttpClient.Builder()
                .proxy(proxy)
                .addInterceptor(interceptor)
                .sslSocketFactory(SSLSocketClientUtil.getSocketFactory(manager), manager)// 忽略校验
                .hostnameVerifier(SSLSocketClientUtil.getHostnameVerifier())//忽略校验
                .build();
        client.dispatcher().setMaxRequests(50);
        client.dispatcher().setMaxRequestsPerHost(50);
        return client;

    }


}
