package cn.ironblog.m3u8;

import cn.ironblog.common.CommonRequest;
import cn.ironblog.common.DownloadManager;
import okhttp3.Request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

/**
 * @author WangNing
 **/

public class M3U8DownloadManager implements DownloadManager {

    private final List<String> videoList;
    private final Map<String, String> headers ;
    private final BitSet downloadStatus ;

    public M3U8DownloadManager(List<String> videoList, Map<String, String> headers){

        this.videoList = videoList;
        this.headers = headers;
        downloadStatus = new BitSet(videoList.size());
        downloadStatus.clear();

    }

    @Override
    public List<CommonRequest> getRequest() {

        List<CommonRequest> result = new ArrayList<>();
        for (int i = 0; i < videoList.size(); i++) {
            if(!downloadStatus.get(i)){
                Request request = makeRequest(videoList.get(i));
                result.add(CommonRequest.wrapRequest(request, "index", i));
            }
        }
        return result;

    }

    private Request makeRequest(String url){

        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        headers.forEach(requestBuilder::header);
        return requestBuilder.build();

    }

    /**
     * 更新下载器
     * @param index 已经下载好的片段
     */
    public  void updateDownloadStatus(int index){

        synchronized (downloadStatus){
            downloadStatus.set(index);
        }

    }

    public boolean getDownload(int index){
        return downloadStatus.get(index);
    }



}
