package cn.ironblog.m3u8;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author WangNing
 **/

public class M3U8DownloadCallBack implements Callback {



    private final String parentPath ;

    private final int videoNum ;

    private final AtomicInteger counter;


    private final M3U8DownloadManager m3U8DownloadManager;

    public M3U8DownloadCallBack(String parentPath, int number, AtomicInteger counter, M3U8DownloadManager m3U8DownloadManager){


        this.parentPath = parentPath;

        this.videoNum = number;

        this.counter = counter;

        this.m3U8DownloadManager = m3U8DownloadManager;
    }


    @Override
    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        counter.incrementAndGet();
    }

    @Override
    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try{
            if(response.body() == null){

                return;
            }

            InputStream videoInputStream = response.body().byteStream();
            File cacheFile = new File(parentPath + "/" + videoNum + ".ts");
            boolean failed = false;
            FileOutputStream videoOutputStream = new FileOutputStream(cacheFile);
            try{
                try{
                    IOUtils.copy(videoInputStream, videoOutputStream);
                }catch (IOException e){
                    failed = true;
                }

                response.close();
                videoInputStream.close();
                videoOutputStream.close();

                if(failed){
                    cacheFile.delete();
                }
                m3U8DownloadManager.updateDownloadStatus(videoNum);
            }catch (Exception ignored){

            }
        }finally {

            response.close();
            counter.incrementAndGet();

        }


    }
}
