package cn.ironblog.m3u8;

import org.apache.commons.io.IOUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author WangNing
 */
public class JoinVideoThread extends Thread {

    private final M3U8DownloadManager downloadManager ;

    private final String parentPath;

    private final String videoName;

    private final Integer size;

    private boolean stop = false;

    public JoinVideoThread(M3U8DownloadManager downloadManager, String parentPath, Integer size, String videoName){

        this.downloadManager = downloadManager;

        this.parentPath = parentPath;

        this.videoName = videoName;

        this.size = size;
    }

    @Override
    public void run() {
        File outFile = new File(parentPath + "/"+ videoName +".mp4");
        if(!outFile.exists()){
            try{
                boolean isSuccess = outFile.createNewFile();
            }catch (IOException ignored){
                return;
            }
        }

        FileOutputStream fileOutputStream;
        try{

            fileOutputStream = new FileOutputStream(outFile);
        }catch (IOException e){
            return;
        }

        // 错误20次，放弃合并文件
        int errorCount  = 0;

        for (int i = 0; i < size; i++) {
            while (!stop){
                if(downloadManager.getDownload(i)){
                    errorCount = 0;
                    try {
                        String videoPath = parentPath + "/" + i + ".ts";
                        File tempVideo = new File(videoPath);
                        if(tempVideo.exists()){
                            FileInputStream fileInputStream = new FileInputStream(tempVideo);

                            IOUtils.copy(fileInputStream, fileOutputStream);
                            fileInputStream.close();
                        }
                        break;
                    } catch (IOException ignored) {
                        break;
                    }
                }else {
                    try {
                        errorCount += 1;
                        if(errorCount >= 10){
                            break;
                        }
                        Thread.sleep(1000);
                    }catch (InterruptedException ignored){
                        break;
                    }
                }
            }

        }

        if(!stop){
            // 清理缓存文件
            for (int i = 0; i < size; i++) {

                if(stop){
                    break;
                }


                String videoPath = parentPath + "/" + i + ".ts";
                File tempVideo = new File(videoPath);
                if(tempVideo.exists()&& !stop)
                    tempVideo.delete();
            }
        }


        try {
            fileOutputStream.close();
        } catch (IOException ignored) {

        }
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}
