package cn.ironblog.flv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

/**
 * @author WangNing
 */
public class FlvFileManager {

    private  RandomAccessFile file ;

    private String parentPath;

    private String fileName ;

    private long length;

    private long readLength = 0;

    public FlvFileManager(String parentPath, String fileName, long length){

        this.parentPath = parentPath;
        this.fileName = fileName;
        this.length = length;

        try {
            File dir = new File(parentPath);
            if(!dir.exists()) {
                boolean createResult = dir.mkdirs();
            }
            file = new RandomAccessFile(parentPath +"/"+ fileName+ ".flv", "rw");
            file.setLength(length);

        } catch (IOException e) {
            e.printStackTrace();
            file = null;
        }
    }

    void saveContent(InputStream inputStream, long start) throws IOException {


            file.seek(start);



            byte[] buffer = new byte[1024];
            int length = 0;

            while ((length = inputStream.read(buffer))!=-1){
                    readLength += length;
                    file.write(buffer,0, length);
            }



    }

    public void closeFile() throws IOException {
        file.close();
    }

    public FlvFileManager createNewInstance(){
        return new FlvFileManager(this.parentPath, this.fileName, length);
    }

    public long getReadLength() {
        return readLength;
    }
}
