package cn.ironblog.flv;

import cn.ironblog.common.CommonRequest;
import cn.ironblog.common.DownloadManager;
import okhttp3.Request;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/**
 * @author WangNing
 **/

public class FlvDownloadManager implements DownloadManager {

    private String videoUrl ;

    private final Vector<String> rangeHeaderList = new Vector<>();

    public FlvDownloadManager(String videoUrl, long length, int splitSize){

        this.videoUrl = videoUrl;

        long peerSize = length / splitSize;

        // 初始化分片
        for (int i = 0; i < splitSize ; i++) {

            long start = peerSize * i;
            long end = peerSize+start;
            if(i == splitSize - 1)
                end = length;
            rangeHeaderList.add("bytes="+start+"-"+end);

        }


    }

    @Override
    public List<CommonRequest> getRequest() {
        List<CommonRequest> requests = new ArrayList<>();
        for (String s : rangeHeaderList) {
            Request tempRequest = new Request.Builder().url(videoUrl)
                    .header("RANGE", s)
                    .header("Connection", "close")
                    .build();
            String[] split = s.substring(6).split("-");
            CommonRequest commonRequest = CommonRequest.wrapRequest(tempRequest, "start", Long.valueOf(split[0]),
                    "end", Long.valueOf(split[1]));
            requests.add(commonRequest);
        }
        return requests;

    }

    public void deleteRange(String range){
        rangeHeaderList.remove(range);
    }

    public void addRange(String range){
        rangeHeaderList.add(range);
    }

    public void deleteAndAddRange(String deleteRange, String addRange){
        rangeHeaderList.remove(deleteRange);
        rangeHeaderList.add(addRange);
    }

    public Vector<String> getRangeHeaderList() {
        return rangeHeaderList;
    }
}
