package cn.ironblog.flv;

import okhttp3.*;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author WangNing
 */
public class FlvDownloadCallBack implements Callback {

    private final FlvFileManager flvFileManager;


    private final long start;

    private final long end;

    private final OkHttpClient client;

    private final FlvDownloadManager downloadManager;

    public FlvDownloadCallBack(FlvFileManager flvFileManager, OkHttpClient client,
                               long start, long end, FlvDownloadManager downloadManager){

        this.flvFileManager = flvFileManager;
        this.start = start;
        this.end = end;
        this.client = client;
        this.downloadManager = downloadManager;

    }



    @Override
    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        try {
            flvFileManager.closeFile();
        } catch (IOException ignored) {

        }
        if(start != end){

                makeNewCall(call.request().url().toString(), start, end);

        }

    }

    @Override
    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {

        try {
            if(response.body() ==null){
                return;
            }
            InputStream inputStream = response.body().byteStream();

            try{
                flvFileManager.saveContent(inputStream, start);
            }catch (Exception e){

                    Request newRequest = makeNewCall(call.request().url().toString(), start + flvFileManager.getReadLength(), end);
                    if(newRequest == null){
                        return;
                    }
                    downloadManager.deleteAndAddRange(call.request().header("RANGE"), newRequest.header("RANGE"));


            }
            downloadManager.deleteRange(call.request().header("RANGE"));

        }finally {

            try{
                response.close();
                flvFileManager.closeFile();
            }catch (IOException ignored){

            }
        }
    }

    private Request makeNewCall(String url, long start, long end){
        Request tempRequest = new Request.Builder().url(url)
                .header("RANGE", "bytes="+start+"-"+end)
                .header("Connection","close")
                .build();
        FlvDownloadCallBack newCallback = new FlvDownloadCallBack(flvFileManager.createNewInstance(),
                 client, start, end, downloadManager);


        if(client.dispatcher().executorService().isShutdown() || client.dispatcher().executorService().isTerminated()){
            return null;
        }else {
            client.newCall(tempRequest).enqueue(newCallback);
            return tempRequest;
        }


    }



}
