package cn.ironblog.common;

import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author WangNing
 */
public class DownloadResponseBody extends ResponseBody {

    private Response originalResponse;

    private AtomicLong downloadLength ;

    public DownloadResponseBody(Response originalResponse, AtomicLong downloadLength){
        this.downloadLength = downloadLength;
        this.originalResponse = originalResponse;
    }

    @Nullable
    @Override
    public MediaType contentType() {
        return originalResponse.body().contentType();
    }

    @Override
    public long contentLength() {
        return originalResponse.body().contentLength();
    }

    @NotNull
    @Override
    public BufferedSource source() {
        return  Okio.buffer(new ForwardingSource(originalResponse.body().source()) {

            @Override
            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                long bytesCount = bytesRead == -1 ? 0 : bytesRead;
                downloadLength.addAndGet(bytesCount);
                return bytesRead;
            }

        });
    }
}
