/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.util;

import cn.ironblog.common.DownloadResponseBody;
import cn.ironblog.util.SSLSocketClientUtil;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class Utils {
    private static final Pattern M3U8URLPattern = Pattern.compile(".*\\.ts", 8);

    public static List<String> getVideoList(URL parentURL, String m3u8) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = M3U8URLPattern.matcher(m3u8);
        while (matcher.find()) {
            String abURL = matcher.group();
            try {
                URL url = new URL(parentURL, abURL);
                list.add(url.toString());
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static OkHttpClient getClient(Proxy proxy, final AtomicLong downloadLength) {
        Interceptor interceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new DownloadResponseBody(originalResponse, downloadLength)).build();
            }
        };
        X509TrustManager manager = SSLSocketClientUtil.getX509TrustManager();
        OkHttpClient client = new OkHttpClient.Builder().proxy(proxy).addInterceptor(interceptor).sslSocketFactory(SSLSocketClientUtil.getSocketFactory(manager), manager).hostnameVerifier(SSLSocketClientUtil.getHostnameVerifier()).build();
        client.dispatcher().setMaxRequests(50);
        client.dispatcher().setMaxRequestsPerHost(50);
        return client;
    }
}

