/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.m3u8;

import cn.ironblog.common.CommonRequest;
import cn.ironblog.common.DownloadManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import okhttp3.Request;

public class M3U8DownloadManager
implements DownloadManager {
    private final List<String> videoList;
    private final Map<String, String> headers;
    private final BitSet downloadStatus;

    public M3U8DownloadManager(List<String> videoList, Map<String, String> headers) {
        this.videoList = videoList;
        this.headers = headers;
        this.downloadStatus = new BitSet(videoList.size());
        this.downloadStatus.clear();
    }

    @Override
    public List<CommonRequest> getRequest() {
        ArrayList<CommonRequest> result = new ArrayList<CommonRequest>();
        for (int i = 0; i < this.videoList.size(); ++i) {
            if (this.downloadStatus.get(i)) continue;
            Request request = this.makeRequest(this.videoList.get(i));
            result.add(CommonRequest.wrapRequest(request, "index", i));
        }
        return result;
    }

    private Request makeRequest(String url) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
        return requestBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDownloadStatus(int index) {
        BitSet bitSet = this.downloadStatus;
        synchronized (bitSet) {
            this.downloadStatus.set(index);
        }
    }

    public boolean getDownload(int index) {
        return this.downloadStatus.get(index);
    }
}

