/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.flv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FlvFileManager {
    private RandomAccessFile file;
    private String parentPath;
    private String fileName;
    private long length;
    private long readLength = 0L;

    public FlvFileManager(String parentPath, String fileName, long length) {
        this.parentPath = parentPath;
        this.fileName = fileName;
        this.length = length;
        try {
            File dir = new File(parentPath);
            if (!dir.exists()) {
                boolean bl = dir.mkdirs();
            }
            this.file = new RandomAccessFile(parentPath + "/" + fileName + ".flv", "rw");
            this.file.setLength(length);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.file = null;
        }
    }

    void saveContent(InputStream inputStream, long start) throws IOException {
        this.file.seek(start);
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            this.readLength += (long)length;
            this.file.write(buffer, 0, length);
        }
    }

    public void closeFile() throws IOException {
        this.file.close();
    }

    public FlvFileManager createNewInstance() {
        return new FlvFileManager(this.parentPath, this.fileName, this.length);
    }

    public long getReadLength() {
        return this.readLength;
    }
}

