/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.flv;

import cn.ironblog.common.CommonRequest;
import cn.ironblog.common.DownloadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import okhttp3.Request;

public class FlvDownloadManager
implements DownloadManager {
    private String videoUrl;
    private final Vector<String> rangeHeaderList = new Vector();

    public FlvDownloadManager(String videoUrl, long length, int splitSize) {
        this.videoUrl = videoUrl;
        long peerSize = length / (long)splitSize;
        for (int i = 0; i < splitSize; ++i) {
            long start = peerSize * (long)i;
            long end = peerSize + start;
            if (i == splitSize - 1) {
                end = length;
            }
            this.rangeHeaderList.add("bytes=" + start + "-" + end);
        }
    }

    @Override
    public List<CommonRequest> getRequest() {
        ArrayList<CommonRequest> requests = new ArrayList<CommonRequest>();
        for (String s : this.rangeHeaderList) {
            Request tempRequest = new Request.Builder().url(this.videoUrl).header("RANGE", s).header("Connection", "close").build();
            String[] split = s.substring(6).split("-");
            CommonRequest commonRequest = CommonRequest.wrapRequest(tempRequest, "start", Long.valueOf(split[0]), "end", Long.valueOf(split[1]));
            requests.add(commonRequest);
        }
        return requests;
    }

    public void deleteRange(String range) {
        this.rangeHeaderList.remove(range);
    }

    public void addRange(String range) {
        this.rangeHeaderList.add(range);
    }

    public void deleteAndAddRange(String deleteRange, String addRange) {
        this.rangeHeaderList.remove(deleteRange);
        this.rangeHeaderList.add(addRange);
    }

    public Vector<String> getRangeHeaderList() {
        return this.rangeHeaderList;
    }
}

