/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.flv;

import cn.ironblog.flv.FlvDownloadManager;
import cn.ironblog.flv.FlvFileManager;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class FlvDownloadCallBack
implements Callback {
    private final FlvFileManager flvFileManager;
    private final long start;
    private final long end;
    private final OkHttpClient client;
    private final FlvDownloadManager downloadManager;

    public FlvDownloadCallBack(FlvFileManager flvFileManager, OkHttpClient client, long start, long end, FlvDownloadManager downloadManager) {
        this.flvFileManager = flvFileManager;
        this.start = start;
        this.end = end;
        this.client = client;
        this.downloadManager = downloadManager;
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        try {
            this.flvFileManager.closeFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.start != this.end) {
            this.makeNewCall(call.request().url().toString(), this.start, this.end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try {
            if (response.body() == null) {
                return;
            }
            inputStream = response.body().byteStream();
            try {
                this.flvFileManager.saveContent(inputStream, this.start);
                ** GOTO lbl20
            }
            catch (Exception e) {
                newRequest = this.makeNewCall(call.request().url().toString(), this.start + this.flvFileManager.getReadLength(), this.end);
                if (newRequest == null) {
                    try {
                        response.close();
                        this.flvFileManager.closeFile();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                    return;
                }
                this.downloadManager.deleteAndAddRange(call.request().header("RANGE"), newRequest.header("RANGE"));
lbl20:
                // 2 sources

                this.downloadManager.deleteRange(call.request().header("RANGE"));
            }
        }
        finally {
            try {
                response.close();
                this.flvFileManager.closeFile();
            }
            catch (IOException var3_3) {}
        }
    }

    private Request makeNewCall(String url, long start, long end) {
        Request tempRequest = new Request.Builder().url(url).header("RANGE", "bytes=" + start + "-" + end).header("Connection", "close").build();
        FlvDownloadCallBack newCallback = new FlvDownloadCallBack(this.flvFileManager.createNewInstance(), this.client, start, end, this.downloadManager);
        if (this.client.dispatcher().executorService().isShutdown() || this.client.dispatcher().executorService().isTerminated()) {
            return null;
        }
        this.client.newCall(tempRequest).enqueue((Callback)newCallback);
        return tempRequest;
    }
}

