/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog.common;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadResponseBody
extends ResponseBody {
    private Response originalResponse;
    private AtomicLong downloadLength;

    public DownloadResponseBody(Response originalResponse, AtomicLong downloadLength) {
        this.downloadLength = downloadLength;
        this.originalResponse = originalResponse;
    }

    @Nullable
    public MediaType contentType() {
        return this.originalResponse.body().contentType();
    }

    public long contentLength() {
        return this.originalResponse.body().contentLength();
    }

    @NotNull
    public BufferedSource source() {
        return Okio.buffer((Source)new ForwardingSource((Source)this.originalResponse.body().source()){

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                long bytesCount = bytesRead == -1L ? 0L : bytesRead;
                DownloadResponseBody.this.downloadLength.addAndGet(bytesCount);
                return bytesRead;
            }
        });
    }
}

