/*
 * Decompiled with CFR 0.152.
 */
package cn.ironblog;

import cn.ironblog.VideoCallBack;
import cn.ironblog.common.CommonRequest;
import cn.ironblog.common.DownloadManager;
import cn.ironblog.flv.FlvDownloadCallBack;
import cn.ironblog.flv.FlvDownloadManager;
import cn.ironblog.flv.FlvFileManager;
import cn.ironblog.m3u8.JoinVideoThread;
import cn.ironblog.m3u8.M3U8DownloadCallBack;
import cn.ironblog.m3u8.M3U8DownloadManager;
import cn.ironblog.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class VideoDownloader {
    private ExecutorService threadPool;
    private String videoUrl;
    private OkHttpClient client;
    private VideoCallBack callBack;
    private volatile VideoState currentState = VideoState.DOWNLOAD_READY;
    private String videoPath;
    private String videoName;
    private DownloadManager downloadManager;
    private final AtomicLong downloadLength = new AtomicLong();
    private JoinVideoThread joinTread = null;
    private Future<?> downloadingFuture = null;
    private final Proxy proxy;

    public VideoDownloader(String url, String videoPath, String videoName, VideoCallBack callBack, Proxy proxy, ExecutorService threadPool) {
        boolean success;
        this.proxy = proxy;
        File file = new File(videoPath);
        if (!file.exists() && !(success = file.mkdirs())) {
            this.currentState = VideoState.DOWNLOAD_FAIL;
            callBack.downloadError("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
            return;
        }
        this.videoUrl = url;
        this.client = Utils.getClient(proxy, this.downloadLength);
        this.videoPath = videoPath;
        this.videoName = videoName;
        this.threadPool = threadPool;
        this.callBack = callBack;
    }

    public Future<?> download() {
        if (this.currentState == VideoState.DOWNLOAD_READY) {
            if (this.videoUrl.endsWith(".m3u8")) {
                this.downloadingFuture = this.threadPool.submit(this::downloadM3U8);
                return this.downloadingFuture;
            }
            this.downloadingFuture = this.threadPool.submit(this::downloadFlv);
            return this.downloadingFuture;
        }
        return null;
    }

    private void downloadM3U8() {
        URL videoURL = null;
        try {
            videoURL = new URL(this.videoUrl);
        }
        catch (MalformedURLException e) {
            this.currentState = VideoState.DOWNLOAD_FAIL;
            this.callBack.downloadError("\u7f51\u5740\u683c\u5f0f\u9519\u8bef");
            return;
        }
        Request request = new Request.Builder().url(this.videoUrl).header("referer", "https://" + videoURL.getHost()).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36 Edg/86.0.622.38").build();
        ArrayList<String> videoList = new ArrayList();
        try (Response response2 = this.client.newCall(request).execute();){
            if (response2.body() == null) {
                this.currentState = VideoState.DOWNLOAD_FAIL;
                this.callBack.downloadError("M3U8\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                return;
            }
            String m3u8 = response2.body().string();
            videoList = Utils.getVideoList(request.url().url(), m3u8);
        }
        catch (IOException response2) {
            // empty catch block
        }
        if (videoList.isEmpty()) {
            this.currentState = VideoState.DOWNLOAD_FAIL;
            this.callBack.downloadError("\u4e0b\u8f7dM3U8\u6587\u4ef6\u5931\u8d25");
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("referer", "https://" + videoURL.getHost());
        headers.put("Connection", "close");
        headers.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36 Edg/86.0.622.38");
        if (this.downloadManager == null) {
            this.downloadManager = new M3U8DownloadManager(videoList, headers);
        }
        Vector completedVector = new Vector();
        this.joinTread = new JoinVideoThread((M3U8DownloadManager)this.downloadManager, this.videoPath, videoList.size(), this.videoName);
        Future<?> joinFuture = this.threadPool.submit(this.joinTread);
        AtomicInteger downloadedNum = new AtomicInteger(1);
        for (CommonRequest newRequest : this.downloadManager.getRequest()) {
            if (!(newRequest.getOneExtraData("index") instanceof Integer)) continue;
            int index = (Integer)newRequest.getOneExtraData("index");
            M3U8DownloadCallBack callBack = new M3U8DownloadCallBack(this.videoPath, index, downloadedNum, (M3U8DownloadManager)this.downloadManager);
            this.client.newCall(newRequest.getRequest()).enqueue((Callback)callBack);
        }
        this.currentState = VideoState.DOWNLOADING;
        while (this.client.dispatcher().queuedCallsCount() > 0 || this.client.dispatcher().runningCallsCount() > 0) {
            try {
                if (this.currentState == VideoState.DOWNLOAD_PAUSE) {
                    return;
                }
                long currentDownload = this.downloadLength.get();
                double currentPercent = (double)downloadedNum.get() / (double)videoList.size() * 100.0;
                this.callBack.process(currentPercent, currentDownload);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        try {
            joinFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.currentState = VideoState.DOWNLOAD_SUCCESS;
        }
        this.client.dispatcher().executorService().shutdown();
        if (this.currentState == VideoState.DOWNLOADING) {
            this.callBack.downloadSuccess();
        }
    }

    private void downloadFlv() {
        this.currentState = VideoState.DOWNLOADING;
        Request request = new Request.Builder().url(this.videoUrl).header("RANGE", "bytes=0-").build();
        int splitSize = 20;
        long length = 0L;
        try (Response response = this.client.newCall(request).execute();){
            length = response.body().contentLength();
        }
        catch (IOException | NullPointerException e) {
            this.currentState = VideoState.DOWNLOAD_FAIL;
            this.callBack.downloadError("\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef");
            return;
        }
        if (this.downloadManager == null) {
            this.downloadManager = new FlvDownloadManager(this.videoUrl, length, 20);
        }
        for (CommonRequest newRequest : this.downloadManager.getRequest()) {
            FlvFileManager flvFileManager = new FlvFileManager(this.videoPath, this.videoName, length);
            long start = (Long)newRequest.getOneExtraData("start");
            long end = (Long)newRequest.getOneExtraData("end");
            this.client.newCall(newRequest.getRequest()).enqueue((Callback)new FlvDownloadCallBack(flvFileManager, this.client, start, end, (FlvDownloadManager)this.downloadManager));
        }
        while (this.client.dispatcher().queuedCallsCount() > 0 || this.client.dispatcher().runningCallsCount() > 0) {
            if (this.currentState == VideoState.DOWNLOAD_PAUSE) {
                return;
            }
            long currentDownload = this.downloadLength.get();
            this.callBack.process((double)currentDownload / (double)length * 100.0, currentDownload);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.currentState = VideoState.DOWNLOAD_SUCCESS;
        this.callBack.downloadSuccess();
        this.client.dispatcher().executorService().shutdown();
    }

    public synchronized VideoState getCurrentState() {
        return this.currentState;
    }

    public void stopDownload() {
    }

    public void pauseDownload() {
        long pauseLength = this.downloadLength.get();
        if (this.currentState == VideoState.DOWNLOADING) {
            this.currentState = VideoState.DOWNLOAD_PAUSE;
        }
        System.out.println("\u6e05\u7a7a\u8bf7\u6c42");
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        if (this.downloadingFuture != null) {
            System.out.println("\u5173\u95ed\u4e0b\u8f7d\u7ebf\u7a0b");
            this.downloadingFuture.cancel(true);
        }
        if (this.joinTread != null) {
            System.out.println("\uff01\uff01\uff01\uff01\uff01\u6253\u65ad\u5408\u5e76\u7ebf\u7a0b");
            this.joinTread.setStop(true);
        }
        this.downloadLength.set(pauseLength);
    }

    public Future<?> startDownload() {
        this.client = Utils.getClient(this.proxy, this.downloadLength);
        if (this.currentState == VideoState.DOWNLOAD_PAUSE) {
            this.currentState = VideoState.DOWNLOAD_READY;
            return this.download();
        }
        return null;
    }

    public static enum VideoState {
        DOWNLOAD_READY,
        DOWNLOADING,
        DOWNLOAD_SUCCESS,
        DOWNLOAD_FAIL,
        DOWNLOAD_PAUSE;

    }
}

