package cn.ipokerface.weixin.mp.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.model.media.MpArticle;
import cn.ipokerface.weixin.model.media.MpNewsMessageTuple;
import cn.ipokerface.weixin.model.media.NotifyMessageTuple;
import cn.ipokerface.weixin.mp.message.NotifyMessage;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.ApiResult;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenManager;
import cn.ipokerface.weixin.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class NotifyProxy extends MPlatformProxy {

    private MessageProxy messageProxy;

    public NotifyProxy(TokenManager tokenManager, MessageProxy messageProxy){
        super(tokenManager);
        this.messageProxy = messageProxy;
    }


    /**
     * 发送客服消息(在48小时内不限制发送次数)
     *
     * @param notify
     *            客服消息对象
     * @return 处理结果
     */
    public ApiResult sendNotify(NotifyMessage notify) throws WeixinException {
        return sendNotify(notify, null);
    }

    /**
     * 发送客服消息(在48小时内不限制发送次数)
     *
     * @param notify
     *            客服消息对象
     * @param kfAccount
     *            客服账号 可为空
     * @throws WeixinException
     * @return 处理结果
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140547&token=&lang=zh_CN">发送客服消息</a>
     * @see cn.ipokerface.weixin.model.media.TextMessageTuple
     * @see cn.ipokerface.weixin.model.media.ImageMessageTuple
     * @see cn.ipokerface.weixin.model.media.VoiceMessageTuple
     * @see cn.ipokerface.weixin.model.media.VideoMessageTuple
     * @see cn.ipokerface.weixin.model.media.MusicMessageTuple
     * @see cn.ipokerface.weixin.model.media.NewsMessageTuple
     * @see cn.ipokerface.weixin.model.media.NotifyMessageTuple
     */
    public ApiResult sendNotify(NotifyMessage notify, String kfAccount)
            throws WeixinException {
        NotifyMessageTuple tuple = notify.getTuple();
        if (tuple instanceof MpNewsMessageTuple) {
            MpNewsMessageTuple _news = (MpNewsMessageTuple) tuple;
            List<MpArticle> _articles = _news.getArticles();
            if (StringUtil.isBlank(_news.getMediaId())) {
                if (_articles.isEmpty()) {
                    throw new WeixinException(
                            "notify fail:mediaId or articles is required");
                }
                tuple = new MpNewsMessageTuple(messageProxy.uploadArticle(_articles));
            }
        }
        String msgtype = tuple.getMessageType();
        JSONObject obj = new JSONObject();
        obj.put("touser", notify.getTouser());
        obj.put("msgtype", msgtype);
        obj.put(msgtype, tuple);
        if (StringUtil.isNotBlank(kfAccount)) {
            JSONObject kf = new JSONObject();
            kf.put("kf_account", kfAccount);
            obj.put("customservice", kf);
        }
        String custom_notify_uri = WeixinMPlatformApis.custom_notify_uri;
        Token token = tokenManager.getCache();
        WeixinResponse response = weixinRequestClient.post(
                String.format(custom_notify_uri, token.getAccessToken()),
                obj.toJSONString());

        return response.getAsResult();
    }
}
