package cn.ipokerface.weixin.mp.model.custom;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class CustomChatSession implements Serializable {

    private static final long serialVersionUID = 7236468333492555458L;

    /**
     * 客服账号
     */
    @JSONField(name = "kf_account")
    private String kfAccount;
    /**
     * 用户ID
     */
    @JSONField(name = "openid")
    private String userOpenId;
    /**
     * 创建时间
     */
    @JSONField(name = "createtime")
    private Date createTime;
    /**
     * 最后一条消息的时间,在`获取未接入会话列表`接口中有值
     */
    @JSONField(name = "latest_time")
    private Date latestTime;

    public String getKfAccount() {
        return kfAccount;
    }

    public void setKfAccount(String kfAccount) {
        this.kfAccount = kfAccount;
    }

    public String getUserOpenId() {
        return userOpenId;
    }

    public void setUserOpenId(String userOpenId) {
        this.userOpenId = userOpenId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLatestTime() {
        return latestTime;
    }

    public void setLatestTime(Date latestTime) {
        this.latestTime = latestTime;
    }

    /**
     * 会话计数,如 未接入会话列表
     *
     */
    public static class CustomChatSessionCounter implements Iterable<CustomChatSession>, Serializable {

        private static final long serialVersionUID = -2200434961546270829L;

        @JSONField(name = "count")
        private int count;
        @JSONField(name = "waitcaselist")
        private List<CustomChatSession> kfSessions;

        @Override
        public Iterator<CustomChatSession> iterator() {
            return kfSessions.iterator();
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<CustomChatSession> getKfSessions() {
            return kfSessions;
        }

        public void setKfSessions(List<CustomChatSession> kfSessions) {
            this.kfSessions = kfSessions;
        }

        @Override
        public String toString() {
            return "kfSessionCounter [count=" + count + ", kfSessions=" + kfSessions + "]";
        }
    }

    @Override
    public String toString() {
        return "KfSession [kfAccount=" + kfAccount + ", userOpenId=" + userOpenId + ", createTime=" + createTime
                + ", latestTime=" + latestTime + "]";
    }
}