package cn.ipokerface.weixin.mp.model.custom;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public enum CustomChatRecordOperationCode {
    MISS(1000, "创建未接入会话"),
    ONLINE(1001, "接入会话"),
    CALL(1002, "主动发起会话"),
    CLOSE(1004, "关闭会话"),
    RASE(1005, "抢接会话"),
    RECEIVE1(2001, "公众号收到消息"),
    SEND(2002, "客服发送消息"),
    RECEIVE2(2003, "客服收到消息");
    private int code;
    private String desc;
    private static Map<Integer, CustomChatRecordOperationCode> customRecordOperCodeMap;
    static {
        customRecordOperCodeMap = new HashMap<Integer, CustomChatRecordOperationCode>();
        for (CustomChatRecordOperationCode operCode : CustomChatRecordOperationCode.values()) {
            customRecordOperCodeMap.put(operCode.getCode(), operCode);
        }
    }

    public static CustomChatRecordOperationCode getOper(int code) {
        return customRecordOperCodeMap.get(code);
    }

    CustomChatRecordOperationCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
