package cn.ipokerface.weixin.mp.token;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenCreator;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinTokenCreator extends TokenCreator {

    private final String appid;
    private final String secret;

    /**
     *
     * @param appid
     *            公众号ID
     * @param secret
     *            公众号secret
     */
    public WeixinTokenCreator(String appid, String secret) {
        this.appid = appid;
        this.secret = secret;
    }

    @Override
    public String name() {
        return "mp_token";
    }

    @Override
    public String uniqueid() {
        return appid;
    }

    @Override
    public Token create() throws WeixinException {
        String tokenUrl = String.format(WeixinMPlatformApis.access_token_url, appid, secret);
        WeixinResponse response = weixinRequestClient.get(tokenUrl);
        JSONObject result = response.getAsJson();
        return new Token(result.getString("access_token"), result.getLongValue("expires_in") * 1000l);
    }
}

