package cn.ipokerface.weixin.mp.request;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class WeixinMPlatformApis {

    public static final String api_base_url = "https://api.weixin.qq.com";

    public static final String api_cgi_url = api_base_url + "/cgi-bin";

    public static final String mp_base_url = "https://mp.weixin.qq.com/cgi-bin";

    public static final String weixin_pay_base_url = "http://mch.tenpay.com";

    public static final String weixin_pay_ssl_url = "https://mch.tenpay.com";

    public static final String weixin_pay_gw_url = "https://gw.tenpay.com";

    public static final String weixin_open_url = "https://open.weixin.qq.com";


    public static final String access_token_url = api_cgi_url + "/token?grant_type=client_credential&appid=%s&secret=%s";

    public static final String js_ticket_url = mp_base_url + "/ticket/getticket?access_token=%s&type=%s";


    // 第三方
    public static final String component_token_url = api_cgi_url + "/component/api_component_token";

    public static final String component_code_url = api_cgi_url + "/component/api_create_preauthcode?component_access_token=%s";

    public static final String component_access_token_url = api_cgi_url + "/component/api_authorizer_token?component_access_token=%s";

    public static final String component_oauth_url = mp_base_url + "/componentloginpage?component_appid=%s&pre_auth_code=%s&redirect_uri=%s";

    public static final String component_query_authorization_uri = api_cgi_url + "/component/api_query_auth?component_access_token=%s";

    public static final String component_get_authorizer_uri = api_cgi_url + "/component/api_get_authorizer_info?component_access_token=%s";

    public static final String component_refresh_authorizer_token_uri = api_cgi_url + "/component/api_authorizer_token?component_access_token=%s";

    public static final String component_get_authorizer_option_uri = api_cgi_url + "/component/api_get_authorizer_option?component_access_token=%s";

    public static final String component_set_authorizer_option_uri = api_cgi_url + "/component/api_set_authorizer_option?component_access_token=%s";


    // 第三方接口
    public static final String sns_user_auth_uri = weixin_open_url + "/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";

    public static final String sns_component_user_auth_uri = weixin_open_url + "/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&component_appid=%s#wechat_redirect";

    public static final String sns_user_token_uri = api_base_url + "/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";

    public static final String sns_component_user_token_uri = api_base_url + "/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s&component_access_token=%s";

    public static final String sns_token_refresh_uri = api_base_url + "/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s";

    public static final String sns_component_token_refresh_uri = api_base_url + "/sns/oauth2/component/refresh_token?appid=%s&grant_type=refresh_token&component_appid=%s&component_access_token=%s&refresh_token=%s";

    public static final String sns_auth_token_uri = api_base_url + "/sns/auth?access_token=%s&openid=%s";

    public static final String sns_user_info_uri = api_base_url + "/sns/userinfo?access_token=%s&openid=%s&lang=%s";

    public static final String open_user_auth_uri=weixin_open_url + "/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";

    // 用户相关

    public static final String api_user_info_uri = api_cgi_url + "/user/info?access_token=%s&openid=%s&lang=%s";

    public static final String api_users_info_uri = api_cgi_url + "/user/info/batchget?access_token=%s";

    public static final String api_token_uri = api_cgi_url + "/token?grant_type=client_credential&appid=%s&secret=%s";

    public static final String api_user_following_uri = api_cgi_url + "/user/get?access_token=%s&next_openid=%s";

    public static final String api_username_remark_uri = api_cgi_url + "/user/info/updateremark?access_token=%s";


    // QRcode
    public static final String qr_ticket_uri = api_cgi_url + "/qrcode/create?access_token=%s";

    public static final String qr_image_uri = api_cgi_url + "/showqrcode?ticket=%s";


    //tag 相关
    public static final String tag_create_uri = api_cgi_url + "/tags/create?access_token=%s";

    public static final String tag_get_uri = api_cgi_url + "/tags/get?access_token=%s";

    public static final String tag_update_uri = api_cgi_url + "/tags/update?access_token=%s";

    public static final String tag_delete_uri = api_cgi_url + "/tags/delete?access_token=%s";

    public static final String tag_tagging_uri = api_cgi_url + "/tags/members/batchtagging?access_token=%s";

    public static final String tag_untagging_uri = api_cgi_url + "/tags/members/batchuntagging?access_token=%s";

    public static final String tag_userids_uri = api_cgi_url + "/tags/getidlist?access_token=%s";

    public static final String tag_user_uri = api_cgi_url + "/user/tag/get?access_token=%s";

    public static final String tag_get_black_list_uri = api_cgi_url + "/tags/members/getblacklist?access_token=%s";

    public static final String tag_batch_black_list_uri = api_cgi_url + "/tags/members/batchblacklist?access_token=%s";

    public static final String tag_batch_unblack_list_uri = api_cgi_url + "/tags/members/batchunblacklist?access_token=%s";


    // 菜单相关
    public static final String menu_create_uri = api_cgi_url + "/menu/create?access_token=%s";

    public static final String menu_custome_create_uri = api_cgi_url + "/menu/addconditional?access_token=%s";

    public static final String menu_get_uri = api_cgi_url + "/menu/get?access_token=%s";

    public static final String menu_get_selfmenu_uri = api_cgi_url + "/get_current_selfmenu_info?access_token=%s";

    public static final String menu_delete_uri = api_cgi_url + "/menu/delete?access_token=%s";

    public static final String menu_delete_custom_uri = api_cgi_url + "/menu/delconditional?access_token=%s";

    public static final String menu_trymatch_uri = api_cgi_url + "/menu/trymatch?access_token=%s";


    // 媒体相关
    public static final String media_upload_uri = api_cgi_url + "/media/upload?access_token=%s&type=%s";

    public static final String image_upload_uri = api_cgi_url + "/media/uploadimg?access_token=%s";

    public static final String meida_download_uri = api_cgi_url + "/media/get?access_token=%s&media_id=%s";

    public static final String video_upload_uri = api_cgi_url + "/media/uploadvideo?access_token=%s";

    public static final String material_article_upload_uri = api_cgi_url + "/material/add_news?access_token=%s";

    public static final String material_media_upload_uri = api_cgi_url + "/material/add_material?access_token=%s";

    public static final String material_media_download_uri = api_cgi_url + "/material/get_material?access_token=%s";

    public static final String material_article_update_uri = api_cgi_url + "/material/update_news?access_token=%s";

    public static final String material_media_del_uri = api_cgi_url + "/material/del_material?access_token=%s";

    public static final String material_media_count_uri = api_cgi_url + "/material/get_materialcount?access_token=%s";

    public static final String material_media_list_uri = api_cgi_url + "/material/batchget_material?access_token=%s";

    public static final String article_upload_uri = api_cgi_url + "/media/uploadnews?access_token=%s";

    public static final String message_group_uri = api_cgi_url + "/card/membercard/updateuser?access_token=%s";

    public static final String message_openid_uri = api_cgi_url + "/message/mass/send?access_token=%s";

    public static final String message_delete_uri = api_cgi_url + "/message/mass/delete?access_token=%s";

    public static final String message_preview_uri = api_cgi_url + "/message/mass/preview?access_token=%s";

    public static final String message_get_uri = api_cgi_url + "/message/mass/get?access_token=%s";

    public static final String news_comment_open = api_cgi_url + "/comment/open?access_token=%s";

    public static final String news_comment_close = api_cgi_url + "/comment/close?access_token=%s";

    public static final String news_comment_markelect = api_cgi_url + "/comment/markelect?access_token=%s";

    public static final String news_comment_unmarkelect = api_cgi_url + "/comment/unmarkelect?access_token=%s";

    public static final String news_comment_delete = api_cgi_url + "/comment/delete?access_token=%s";

    public static final String news_comment_reply_add = api_cgi_url + "/comment/reply/add?access_token=%s";

    public static final String news_comment_reply_delete = api_cgi_url + "/comment/reply/delete?access_token=%s";

    public static final String news_comment_list = api_cgi_url + "/comment/list?access_token=%s";

    // 自动回复
    public static final String auto_reply_setting_get_uri= api_cgi_url + "/get_current_autoreply_info?access_token=%s";

    public static final String custom_notify_uri= api_cgi_url + "/message/custom/send?access_token=%s";

    // 模版消息
    public static final String template_set_industry_uri= api_cgi_url + "/template/api_set_industry?access_token=%s";

    public static final String template_get_industry_uri= api_cgi_url + "/template/get_industry?access_token=%s";

    public static final String template_get_id_uri= api_cgi_url + "/template/api_add_template?access_token=%s";

    public static final String template_get_all_uri= api_cgi_url + "/template/get_all_private_template?access_token=%s";

    public static final String template_del_uri= api_cgi_url + "/template/del_private_template?access_token=%s";

    public static final String template_send_uri= api_cgi_url + "/message/template/send?access_token=%s";


    // 卡券相关
    public static final String card_create_uri = api_base_url + "/card/create?access_token=%s";

    public static final String card_pay_cell_uri = api_base_url + "/card/paycell/set?access_token=%s";

    public static final String card_self_consume_cell_uri = api_base_url + "/card/selfconsumecell/set?access_token=%s";

    public static final String card_qr_ticket_uri = api_base_url + "/card/qrcode/create?access_token=%s";

    public static final String card_update_uri = api_base_url + "/card/update?access_token=%s";

    public static final String card_set_test_whitelist_uri = api_base_url + "/card/testwhitelist/set?access_token=%s";

    public static final String card_get_uri = api_base_url + "/card/get?access_token=%s";

    public static final String card_member_card_activate_uri = api_base_url + "/card/membercard/activate?access_token=%s";

    public static final String card_member_card_activate_user_form_uri = api_base_url + "/card/membercard/activateuserform/set?access_token=%s";

    public static final String card_member_card_user_info_uri = api_base_url + "/card/membercard/userinfo/get?access_token=%s";

    public static final String card_member_card_update_user_uri = api_base_url + "/card/membercard/updateuser?access_token=%s";


    // 客服
    public static final String custom_chat_record_uri = api_base_url + "/customservice/msgrecord/getmsglist?access_token=%s";

    public static final String custom_list_uri = api_cgi_url + "/customservice/getkflist?access_token=%s";

    public static final String custom_online_list_uri = api_cgi_url + "/customservice/getonlinekflist?access_token=%s";

    public static final String custom_create_uri = api_base_url + "/customservice/kfaccount/add?access_token=%s";

    public static final String custom_invite_uri = api_base_url + "/customservice/kfaccount/inviteworker?access_token=%s";

    public static final String custom_update_uri = api_base_url + "/customservice/kfaccount/update?access_token=%s";

    public static final String custom_avatar_uri = api_base_url + "/customservice/kfaccount/uploadheadimg?access_token=%s&kf_account=%s";

    public static final String custom_delete_uri = api_base_url + "/customservice/kfaccount/del?access_token=%s&kf_account=%s";

    public static final String custom_session_create_uri = api_base_url + "/customservice/kfsession/create?access_token=%s";

    public static final String custom_session_close_uri = api_base_url + "/customservice/kfsession/close?access_token=%s";

    public static final String custom_session_get_uri = api_base_url + "/customservice/kfsession/getsession?access_token=%s&openid=%s";

    public static final String custom_session_list_uri = api_base_url + "/customservice/kfsession/getsessionlist?access_token=%s&kf_account=%s";

    public static final String custom_session_wait_uri = api_base_url + "/customservice/kfsession/getwaitcase?access_token=%s";

    // 摇一摇
    public static final String shake_device_apply_uri = api_base_url + "/shakearound/device/applyid?access_token=%s";

    public static final String shake_device_apply_status_uri = api_base_url + "/shakearound/device/applystatus?access_token=%s";

    public static final String shake_device_update_uri = api_base_url + "/shakearound/device/update?access_token=%s";

    public static final String shake_device_search_uri = api_base_url + "/shakearound/device/search?access_token=%s";

    public static final String shake_user_get_shake_info = api_base_url + "/shakearound/user/getshakeinfo?access_token=%s";


    // 工具
    // 短链接
    public static final String short_url_uri= api_cgi_url+ "/shorturl?access_token=%s";
    // 语义理解
    public static final String semantic_uri= api_base_url+ "/semantic/semproxy/search?access_token=%s";
    // 微信服务器地址列表
    public static final String get_callback_ip_uri= api_cgi_url + "/getcallbackip?access_token=%s";
    // 接口调用次数清零
    public static final String clear_quota_uri= api_cgi_url + "/clear_quota?access_token=%s";



    // 统计
    public static final String datacube_uri = api_base_url + "/datacube/%s?access_token=%s";


}
