package cn.ipokerface.weixin.mp.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.model.qrcode.QrcodeParameter;
import cn.ipokerface.weixin.model.qrcode.QrcodeResult;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenManager;
import cn.ipokerface.weixin.utils.IOUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import java.io.IOException;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class QrcodeProxy extends MPlatformProxy {


    public QrcodeProxy(TokenManager tokenManager){
        super(tokenManager);
    }

    /**
     * 生成带参数的二维码
     *
     * @param parameter
     *            二维码参数
     * @return 二维码结果对象
     * @throws WeixinException
     * @see cn.ipokerface.weixin.model.qrcode.QrcodeResult
     * @see cn.ipokerface.weixin.model.qrcode.QrcodeParameter
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1443433542&token=&lang=zh_CN">生成二维码</a>
     */
    public QrcodeResult createQR(QrcodeParameter parameter) throws WeixinException {
        Token token = tokenManager.getCache();
        String qr_uri = WeixinMPlatformApis.qr_ticket_uri;
        WeixinResponse response = weixinRequestClient.post(
                String.format(qr_uri, token.getAccessToken()),
                JSON.toJSONString(parameter));
        QrcodeResult result = response.getAsObject(new TypeReference<QrcodeResult>() {
        });
        qr_uri = String.format(WeixinMPlatformApis.qr_image_uri,
                result.getTicket());
        response = weixinRequestClient.get(qr_uri);
        result.setShowUrl(qr_uri);
        try {
            result.setContent(IOUtils.toByteArray(response.getBody()));
        } catch (IOException e) {
            throw new WeixinException(e);
        }
        return result;
    }

}
