package cn.ipokerface.weixin.mp.model.data;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ArticleTotal implements Serializable {
    private static final long serialVersionUID = -6820948857241500950L;

    /**
     * 数据的日期
     */
    @JSONField(name = "ref_date")
    private Date refDate;
    /**
     * 这里的msgid实际上是由msgid（图文消息id）和index（消息次序索引）组成， 例如12003_3，
     * 其中12003是msgid，即一次群发的id消息的； 3为index，假设该次群发的图文消息共5个文章（因为可能为多图文）， 3表示5个中的第3个
     */
    @JSONField(name = "msgid")
    private String msgId;
    /**
     * 图文消息的标题
     */
    private String title;
    /**
     * 详细信息
     */
    private List<ArticleDatacubeTwo> details;

    public Date getRefDate() {
        return refDate;
    }

    public void setRefDate(Date refDate) {
        this.refDate = refDate;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ArticleDatacubeTwo> getDetails() {
        return details;
    }

    public void setDetails(List<ArticleDatacubeTwo> details) {
        this.details = details;
    }

    @Override
    public String toString() {
        return "ArticleTotal [refDate=" + refDate + ", msgId=" + msgId
                + ", title=" + title + ", details=" + details + "]";
    }
}