package cn.ipokerface.weixin.mp.component;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TicketPermanentManager;
import cn.ipokerface.weixin.token.TokenCreator;
import cn.ipokerface.weixin.token.TokenManager;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinTokenComponentCreator extends TokenCreator {

    private final TicketPermanentManager perTicketManager;
    private final TokenManager componentTokenManager;

    /**
     *
     * @param perTicketManager
     *            第三方套件永久授权码
     * @param componentTokenManager
     *            第三方套件凭证token
     */
    public WeixinTokenComponentCreator(TicketPermanentManager perTicketManager, TokenManager componentTokenManager) {
        this.perTicketManager = perTicketManager;
        this.componentTokenManager = componentTokenManager;
    }

    @Override
    public String name() {
        return String.format("mp_token_component_%s_%s", perTicketManager.getThirdId(),
                perTicketManager.getAuthAppId());
    }

    @Override
    public String uniqueid() {
        return String.format("%s_%s", perTicketManager.getThirdId(), perTicketManager.getAuthAppId());
    }

    @Override
    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("component_appid", perTicketManager.getThirdId());
        obj.put("authorizer_appid", perTicketManager.getAuthAppId());
        obj.put("authorizer_refresh_token", perTicketManager.getAccessTicket());
        WeixinResponse response = weixinRequestClient.post(
                String.format(WeixinMPlatformApis.component_token_url, componentTokenManager.getAccessToken()),
                obj.toJSONString());
        obj = response.getAsJson();
        perTicketManager.cachingTicket(obj.getString("authorizer_refresh_token"));
        return new Token(obj.getString("authorizer_access_token"), obj.getLongValue("expires_in") * 1000l);
    }
}
