package cn.ipokerface.weixin.mp.component;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TicketManager;
import cn.ipokerface.weixin.token.TokenCreator;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinComponentTokenCreator extends TokenCreator {
    private final TicketManager ticketManager;

    /**
     *
     * @param ticketManager
     *            组件ticket存取
     */
    public WeixinComponentTokenCreator(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
    }

    @Override
    public String name() {
        return "mp_component_token";
    }

    @Override
    public String uniqueid() {
        return ticketManager.getThirdId();
    }

    @Override
    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("component_appid", ticketManager.getThirdId());
        obj.put("component_appsecret", ticketManager.getThirdSecret());
        obj.put("component_verify_ticket", ticketManager.getAccessTicket());
        WeixinResponse response = weixinRequestClient.post(WeixinMPlatformApis.component_token_url, obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("component_access_token"), obj.getLongValue("expires_in") * 1000l);
    }
}