package cn.ipokerface.weixin.mp.component;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenCreator;
import cn.ipokerface.weixin.token.TokenManager;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinComponentPreCodeCreator extends TokenCreator {

    private final TokenManager componentTokenManager;
    private final String componentId;

    /**
     *
     * @param componentTokenManager
     *            应用套件的token
     * @param componentId
     *            应用组件ID
     */
    public WeixinComponentPreCodeCreator(TokenManager componentTokenManager, String componentId) {
        this.componentTokenManager = componentTokenManager;
        this.componentId = componentId;
    }

    @Override
    public String name() {
        return "mp_component_precode";
    }

    @Override
    public String uniqueid() {
        return componentId;
    }

    @Override
    public Token create() throws WeixinException {
        WeixinResponse response = weixinRequestClient.post(
                String.format(WeixinMPlatformApis.component_code_url, componentTokenManager.getAccessToken()),
                String.format("{\"component_appid\":\"%s\"}", componentId));
        JSONObject result = response.getAsJson();
        return new Token(result.getString("pre_auth_code"), result.getLongValue("expires_in") * 1000l);
    }

}
