package cn.ipokerface.weixin.mp.token;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.TicketType;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenCreator;
import cn.ipokerface.weixin.token.TokenManager;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinTicketCreator extends TokenCreator {

    private final TicketType ticketType;
    private final TokenManager weixinTokenManager;

    /**
     * jssdk
     *
     * @param ticketType
     *            票据类型
     * @param weixinTokenManager
     *            <font color="red">公众平台的access_token</font>
     */
    public WeixinTicketCreator(TicketType ticketType, TokenManager weixinTokenManager) {
        this.ticketType = ticketType;
        this.weixinTokenManager = weixinTokenManager;
    }

    @Override
    public String name() {
        return String.format("mp_ticket_%s", ticketType.name());
    }

    @Override
    public String uniqueid() {
        return weixinTokenManager.getWeixinId();
    }

    @Override
    public Token create() throws WeixinException {
        WeixinResponse response = weixinRequestClient
                .get(String.format(WeixinMPlatformApis.js_ticket_url, weixinTokenManager.getAccessToken(), ticketType.name()));
        JSONObject result = response.getAsJson();
        return new Token(result.getString("ticket"), result.getLongValue("expires_in") * 1000l);
    }
}
