package cn.ipokerface.weixin.mp.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.mp.model.data.DatacubeType;
import cn.ipokerface.weixin.mp.request.WeixinMPlatformApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.token.TokenManager;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class DataProxy extends MPlatformProxy {

    public DataProxy(TokenManager tokenManager){
        super(tokenManager);
    }


    /**
     * 数据统计
     *
     * @param datacubeType
     *            统计类型
     * @param beginDate
     *            开始日期
     * @param offset
     *            增量 表示向前几天 比如 offset=1 则查询 beginDate的后一天之间的数据
     * @throws WeixinException
     */
    public List<?> datacube(DatacubeType datacubeType, Date beginDate,
                            int offset) throws WeixinException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginDate);
        ca.add(Calendar.DAY_OF_MONTH, offset);
        return datacube(datacubeType, beginDate, ca.getTime());
    }

    /**
     * 数据统计
     *
     * @param datacubeType
     *            统计类型
     * @param offset
     *            增量 表示向后几天 比如 offset=1 则查询 beginDate的前一天之间的数据
     * @param endDate
     *            截至日期
     * @throws WeixinException
     */
    public List<?> datacube(DatacubeType datacubeType, int offset, Date endDate)
            throws WeixinException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(Calendar.DAY_OF_MONTH, 0 - offset);
        return datacube(datacubeType, ca.getTime(), endDate);
    }

    /**
     * 查询日期跨度为0的统计数据(当天)
     *
     * @param datacubeType
     *            统计类型
     * @param date
     *            统计日期
     * @throws WeixinException
     */
    public List<?> datacube(DatacubeType datacubeType, Date date)
            throws WeixinException {
        return datacube(datacubeType, date, date);
    }

    /**
     * 数据统计
     *
     * @param datacubeType
     *            数据统计类型
     * @param beginDate
     *            获取数据的起始日期，begin_date和end_date的差值需小于“最大时间跨度”（比如最大时间跨度为1时，
     *            begin_date和end_date的差值只能为0，才能小于1），否则会报错
     * @param endDate
     *            获取数据的结束日期，end_date允许设置的最大值为昨日
     * @see cn.ipokerface.weixin.mp.model.data.UserSummary
     * @see cn.ipokerface.weixin.mp.model.data.ArticleSummary
     * @see cn.ipokerface.weixin.mp.model.data.ArticleTotal
     * @see cn.ipokerface.weixin.mp.model.data.ArticleDatacubeShare
     * @see cn.ipokerface.weixin.mp.model.data.UpstreamMessage
     * @see cn.ipokerface.weixin.mp.model.data.UpstreamMessageDist
     * @see cn.ipokerface.weixin.mp.model.data.InterfaceSummary
     * @return 统计结果
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141082&token=&lang=zh_CN">用户分析</a>
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141084&token=&lang=zh_CN">图文分析</a>
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141085&token=&lang=zh_CN">消息分析</a>
     * @see <a
     *      href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141086&token=&lang=zh_CN">接口分析</a>
     * @throws WeixinException
     */
    public List<?> datacube(DatacubeType datacubeType, Date beginDate,
                            Date endDate) throws WeixinException {
        String datacube_uri = WeixinMPlatformApis.datacube_uri;
        Token token = tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("begin_date", DateUtils.fortmat2yyyy_MM_dd(beginDate));
        obj.put("end_date", DateUtils.fortmat2yyyy_MM_dd(endDate));
        WeixinResponse response = weixinRequestClient.post(String.format(datacube_uri,
                datacubeType.name().toLowerCase(), token.getAccessToken()), obj
                .toJSONString());

        return JSON.parseArray(response.getAsJson().getString("list"),
                datacubeType.getClazz());
    }
}
