package cn.ipokerface.weixin.mp.model.component;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public final class ComponentAuthorizerOption implements Serializable {

    private static final long serialVersionUID = -3124882411789627403L;

    /**
     * 选项名称
     *
     */
    public enum AuthorizerOptionName {
        /**
         * 地理位置上报选项
         */
        location_report,
        /**
         * 语音识别开关选项
         */
        voice_recognize,
        /**
         * 多客服开关选项
         */
        customer_service;
    }

    private AuthorizerOptionName name;
    private int value;
    private List<Integer> options;

    private ComponentAuthorizerOption(AuthorizerOptionName name, int value,
                             Integer... options) {
        this.name = name;
        this.value = value;
        this.options = Arrays.asList(options);
    }

    /**
     * 地理位置上报选项
     *
     * @param value
     *            选项值
     * @return 选项对象
     */
    public static ComponentAuthorizerOption createLocationReportOption(int value) {
        return new ComponentAuthorizerOption(AuthorizerOptionName.location_report,
                value, 0, 1, 2);
    }

    /**
     * 语音识别开关选项
     *
     * @param value
     *            选项值
     * @return 选项对象
     */
    public static ComponentAuthorizerOption createVoiceRecognizeOption(int value) {
        return new ComponentAuthorizerOption(AuthorizerOptionName.voice_recognize,
                value, 0, 1);
    }

    /**
     * 多客服开关选项
     *
     * @param value
     *            选项值
     * @return 选项对象
     */
    public static ComponentAuthorizerOption createCustomerServiceOption(int value) {
        return new ComponentAuthorizerOption(AuthorizerOptionName.customer_service,
                value, 0, 1);
    }

    /**
     * 返回选项对象
     *
     * @param optionName
     *            选项名
     * @param optionValue
     *            选项值
     * @return 选项对象
     */
    public static ComponentAuthorizerOption parse(AuthorizerOptionName optionName,
                                         int optionValue) {
        if (optionName == AuthorizerOptionName.customer_service) {
            return createCustomerServiceOption(optionValue);
        } else if (optionName == AuthorizerOptionName.location_report) {
            return createLocationReportOption(optionValue);
        } else if (optionName == AuthorizerOptionName.voice_recognize) {
            return createVoiceRecognizeOption(optionValue);
        } else {
            throw new IllegalArgumentException("unkown option:" + optionName);
        }
    }

    public AuthorizerOptionName getName() {
        return name;
    }

    public int getValue() {
        return value;
    }

    public List<Integer> getOptions() {
        return options;
    }

    @Override
    public String toString() {
        return "AuthorizerOption [name=" + name + ", value=" + value
                + ", options=" + options + "]";
    }
}
