package cn.ipokerface.weixin.mp.model;

import cn.ipokerface.weixin.model.WeixinAccount;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinMPlatformAccount extends WeixinAccount {

    private static final long serialVersionUID = 3689999353867189585L;
    /**
     * 多个应用组件信息
     */
    private List<WeixinAccount> components;

    /**
     *
     * @param appId
     *            应用ID 使用普通接口(WeixinProxy对象)必须填写
     * @param appSecret
     *            应用密钥 使用普通接口(WeixinProxy对象)必须填写
     * @param components
     *            应用组件集合 使用套件接口(WeixinComponentProxy#ComponentApi)必须填写
     */
    @JSONCreator
    public WeixinMPlatformAccount(@JSONField(name = "id") String appId, @JSONField(name = "secret") String appSecret,
                                  @JSONField(name = "components") List<WeixinAccount> components) {
        super(appId, appSecret);
        this.components = components;
    }

    public List<WeixinAccount> getComponents() {
        return components;
    }

    @Override
    public String toString() {
        return "WeixinMpAccount [" + super.toString() + ", components=" + components + "]";
    }
}