/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.token;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicketManager {
    private final String thirdId;
    private final String thirdSecret;
    private final AbstractCacheStorager<Token> cacheStorager;

    public TicketManager(String thirdId, String thirdSecret, AbstractCacheStorager<Token> cacheStorager) {
        this.thirdId = thirdId;
        this.thirdSecret = thirdSecret;
        this.cacheStorager = cacheStorager;
    }

    public Token getTicket() throws WeixinException {
        return this.cacheStorager.lookup(this.getCacheKey());
    }

    public String getAccessTicket() throws WeixinException {
        return this.getTicket().getAccessToken();
    }

    public String getCacheKey() {
        return String.format("%sthird_party_ticket_%s", "weixin_", this.thirdId);
    }

    public void cachingTicket(String ticket) throws WeixinException {
        Token token = new Token(ticket);
        this.cacheStorager.caching(this.getCacheKey(), token);
    }

    public String getThirdId() {
        return this.thirdId;
    }

    public String getThirdSecret() {
        return this.thirdSecret;
    }

    public AbstractCacheStorager<Token> getCacheStorager() {
        return this.cacheStorager;
    }
}

