/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.simple;

import cn.ipokerface.weixin.request.http.AbstractHttpClient;
import cn.ipokerface.weixin.request.http.HttpClientException;
import cn.ipokerface.weixin.request.http.HttpClientFactory;
import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpParams;
import cn.ipokerface.weixin.request.http.HttpRequest;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import cn.ipokerface.weixin.request.http.simple.SimpleHttpResponse;
import cn.ipokerface.weixin.utils.IOUtils;
import cn.ipokerface.weixin.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class SimpleHttpClient
extends AbstractHttpClient {
    private final HttpParams params;

    public SimpleHttpClient(HttpParams params) {
        this.params = params;
    }

    protected HttpURLConnection createHttpConnection(HttpRequest request) throws IOException {
        URLConnection urlConnection;
        URI uri = request.getURI();
        Proxy proxy = this.params != null ? this.params.getProxy() : null;
        URLConnection uRLConnection = urlConnection = proxy != null ? uri.toURL().openConnection(proxy) : uri.toURL().openConnection();
        if (uri.getScheme().equals("https")) {
            SSLContext sslContext = null;
            HostnameVerifier hostnameVerifier = null;
            if (this.params != null) {
                sslContext = this.params.getSSLContext();
                hostnameVerifier = this.params.getHostnameVerifier();
            }
            if (sslContext == null) {
                sslContext = HttpClientFactory.allowSSLContext();
            }
            if (hostnameVerifier == null) {
                hostnameVerifier = HttpClientFactory.AllowHostnameVerifier.GLOBAL;
            }
            HttpsURLConnection connection = (HttpsURLConnection)urlConnection;
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            connection.setHostnameVerifier(hostnameVerifier);
            return connection;
        }
        return (HttpURLConnection)urlConnection;
    }

    public HttpResponse execute(HttpRequest request) throws HttpClientException {
        HttpResponse response = null;
        try {
            HttpURLConnection connection = this.createHttpConnection(request);
            String method = request.getMethod().name();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects("GET".equals(method));
            if ("PUT".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "DELETE".equals(method)) {
                connection.setDoOutput(true);
            } else {
                connection.setDoOutput(false);
            }
            HttpHeaders headers = request.getHeaders();
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if (!headers.containsKey("Host")) {
                headers.set("Host", request.getURI().getHost());
            }
            if (!headers.containsKey("Accept")) {
                headers.set("Accept", "*/*");
            }
            if (!headers.containsKey("User-Agent")) {
                headers.set("User-Agent", "jdk/httpclient");
            }
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if ("Cookie".equalsIgnoreCase(header.getKey())) {
                    connection.setRequestProperty(header.getKey(), StringUtil.join((Iterable)header.getValue(), ';'));
                    continue;
                }
                for (String headerValue : header.getValue()) {
                    connection.addRequestProperty(header.getKey(), headerValue != null ? headerValue : "");
                }
            }
            HttpEntity httpEntity = request.getEntity();
            if (httpEntity != null) {
                connection.setUseCaches(false);
                if (httpEntity.getContentLength() > 0L) {
                    connection.setRequestProperty("Content-Length", Long.toString(httpEntity.getContentLength()));
                }
                if (httpEntity.getContentType() != null) {
                    connection.setRequestProperty("Content-Type", httpEntity.getContentType().toString());
                }
            }
            connection.connect();
            if (httpEntity != null) {
                OutputStream output = connection.getOutputStream();
                httpEntity.writeTo(output);
                output.flush();
                output.close();
            }
            InputStream input = connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
            byte[] content = IOUtils.toByteArray(input);
            response = new SimpleHttpResponse(connection, content);
            input.close();
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + request.getMethod().name() + " request for \"" + request.getURI().toString(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return response;
    }
}

