/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.request.http.message.AbstractMessageConverter;
import cn.ipokerface.weixin.utils.FileUtils;
import cn.ipokerface.weixin.utils.RegexUtil;
import cn.ipokerface.weixin.xml.XmlFormatter;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMessageConverter
extends AbstractMessageConverter {
    public static final XmlMessageConverter GLOBAL = new XmlMessageConverter();
    private static final String XML = "xml";
    private static final int BRACKET = 60;

    public XmlMessageConverter() {
        super(MimeType.APPLICATION_XML, MimeType.TEXT_XML, new MimeType("application", "*+xml"));
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        if (!super.canConvert(clazz, response)) {
            String disposition = response.getHeaders().getFirst("Content-Disposition");
            String fileName = RegexUtil.regexFileNameFromContentDispositionHeader(disposition);
            return fileName != null && FileUtils.getFileExtension(fileName).equalsIgnoreCase(XML);
        }
        return true;
    }

    @Override
    protected boolean supports(Class<?> clazz, byte[] content) {
        return 60 == content[0];
    }

    @Override
    protected <T> T convertInternal(Class<? extends T> clazz, InputStream body) throws IOException {
        return XmlFormatter.fromXML(body, clazz);
    }
}

