/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.request.http.message.MessageConverter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageConverter
implements MessageConverter {
    protected Charset charset = Constant.UTF_8;
    private List<MimeType> supportedMimeTypes;

    protected AbstractMessageConverter() {
        this.supportedMimeTypes = Collections.emptyList();
    }

    protected AbstractMessageConverter(MimeType supportedMimeType) {
        this.setSupportedMediaTypes(Collections.singletonList(supportedMimeType));
    }

    protected AbstractMessageConverter(MimeType ... supportedMimeTypes) {
        this.setSupportedMediaTypes(Arrays.asList(supportedMimeTypes));
    }

    public void setSupportedMediaTypes(List<MimeType> supportedMimeTypes) {
        this.supportedMimeTypes = new ArrayList<MimeType>(supportedMimeTypes);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public List<MimeType> supportedMimeTypes() {
        return Collections.unmodifiableList(this.supportedMimeTypes);
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        MimeType mimeType = MimeType.valueOf(response.getHeaders().getContentType());
        byte[] content = response.getContent();
        return this.supports(clazz, mimeType) || this.supports(clazz, content);
    }

    protected boolean supports(Class<?> clazz, MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType supportedMediaType : this.supportedMimeTypes()) {
            if (!supportedMediaType.includes(mimeType)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean supports(Class<?> var1, byte[] var2);

    @Override
    public <T> T convert(Class<? extends T> clazz, HttpResponse response) throws IOException {
        return this.convertInternal(clazz, response.getBody());
    }

    protected abstract <T> T convertInternal(Class<? extends T> var1, InputStream var2) throws IOException;
}

