/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.entity;

import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileEntity
implements HttpEntity {
    private final File file;
    private final ContentType contentType;

    public FileEntity(File file) {
        this(file, ContentType.DEFAULT_BINARY);
    }

    public FileEntity(File file, ContentType contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        FileInputStream instream = new FileInputStream(this.file);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)instream).read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
            outstream.flush();
        }
        finally {
            ((InputStream)instream).close();
        }
    }
}

