/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http.entity;

import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayEntity
implements HttpEntity {
    private final ContentType contentType;
    private final byte[] content;
    private final int off;
    private final int len;

    public ByteArrayEntity(byte[] content) {
        this(content, ContentType.DEFAULT_BINARY);
    }

    public ByteArrayEntity(byte[] content, ContentType contentType) {
        this(content, 0, content.length, contentType);
    }

    public ByteArrayEntity(byte[] content, int off, int len, ContentType contentType) {
        this.content = content;
        this.off = off;
        this.len = len;
        this.contentType = contentType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.len;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content, this.off, this.len);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.content, this.off, this.len);
        outstream.flush();
    }
}

