/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.request.http.HttpClient;
import cn.ipokerface.weixin.request.http.HttpParams;
import cn.ipokerface.weixin.request.http.netty.Netty4HttpClientFactory;
import cn.ipokerface.weixin.request.http.simple.SimpleHttpClientFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public abstract class HttpClientFactory {
    private static volatile HttpClientFactory defaultFactory = HttpClientFactory.newDefaultFactory();
    private static volatile HttpParams defaultParams;

    private static HttpClientFactory newDefaultFactory() {
        HttpClientFactory f;
        try {
            f = new Netty4HttpClientFactory();
        }
        catch (Throwable e1) {
            f = new SimpleHttpClientFactory();
        }
        return f;
    }

    public static HttpClientFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(HttpClientFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new IllegalArgumentException("'defaultFactory' must not be empty");
        }
        HttpClientFactory.defaultFactory = defaultFactory;
    }

    public static HttpParams getDefaultParams() {
        return defaultParams;
    }

    public static void setDefaultParams(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("'params' must not be empty");
        }
        defaultParams = params;
    }

    public static HttpClient getInstance() {
        return HttpClientFactory.getInstance(defaultParams);
    }

    public static HttpClient getInstance(HttpParams params) {
        HttpClientFactory clientFactory = HttpClientFactory.getDefaultFactory();
        return clientFactory.newInstance(params);
    }

    public abstract HttpClient newInstance(HttpParams var1);

    public static SSLContext allowSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{AllowX509TrustManager.GLOBAL}, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Create SSLContext NoSuchAlgorithmException:", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Create SSLContext KeyManagementException:", e);
        }
    }

    public static class AllowHostnameVerifier
    implements HostnameVerifier {
        public static final HostnameVerifier GLOBAL = new AllowHostnameVerifier();

        private AllowHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class AllowX509TrustManager
    implements X509TrustManager {
        public static final X509TrustManager GLOBAL = new AllowX509TrustManager();

        private AllowX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }
    }
}

