/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.request.ApiResult;
import cn.ipokerface.weixin.request.ApiXmlResult;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.request.http.HttpClient;
import cn.ipokerface.weixin.request.http.HttpClientException;
import cn.ipokerface.weixin.request.http.HttpClientFactory;
import cn.ipokerface.weixin.request.http.HttpMethod;
import cn.ipokerface.weixin.request.http.HttpParams;
import cn.ipokerface.weixin.request.http.HttpRequest;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.request.http.URLParameter;
import cn.ipokerface.weixin.request.http.apache.FormBodyPart;
import cn.ipokerface.weixin.request.http.apache.HttpMultipartMode;
import cn.ipokerface.weixin.request.http.apache.MultipartEntityBuilder;
import cn.ipokerface.weixin.request.http.entity.FormUrlEntity;
import cn.ipokerface.weixin.request.http.entity.StringEntity;
import cn.ipokerface.weixin.request.http.message.XmlMessageConverter;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class WeixinRequestClient {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final String SUCCESS_CODE = ",0,success,";
    private final HttpClient httpClient;

    public WeixinRequestClient() {
        this.httpClient = HttpClientFactory.getInstance();
    }

    public WeixinRequestClient(HttpParams params) {
        this.httpClient = HttpClientFactory.getInstance(params);
    }

    public WeixinResponse post(String url, String body) throws WeixinException {
        StringEntity entity = new StringEntity(body);
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    public WeixinResponse post(String url, FormBodyPart ... bodyParts) throws WeixinException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (FormBodyPart bodyPart : bodyParts) {
            builder.addPart(bodyPart);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(builder.setMode(HttpMultipartMode.RFC6532).buildEntity());
        return this.doRequest(request);
    }

    public WeixinResponse get(String url, URLParameter ... parameters) throws WeixinException {
        StringBuilder buf = new StringBuilder(url);
        if (parameters != null && parameters.length > 0) {
            buf.append("&").append(FormUrlEntity.formatParameters(Arrays.asList(parameters)));
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, buf.toString());
        return this.doRequest(request);
    }

    public WeixinResponse doRequest(HttpRequest request) throws WeixinException {
        try {
            if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
                this.logger.debug("weixin request >> " + (Object)((Object)request.getMethod()) + " " + request.getURI().toString() + (request.getEntity() instanceof StringEntity ? " >> " + ((StringEntity)request.getEntity()).getContentString() : ""));
            }
            HttpResponse httpResponse = this.httpClient.execute(request);
            WeixinResponse response = new WeixinResponse(httpResponse);
            this.handleResponse(response);
            return response;
        }
        catch (HttpClientException e) {
            throw new WeixinException(e);
        }
    }

    private boolean hasStreamMimeType(WeixinResponse response) {
        MimeType responseMimeType = MimeType.valueOf(response.getHeaders().getContentType());
        for (MimeType streamMimeType : MimeType.STREAM_MIMETYPES) {
            if (!streamMimeType.includes(responseMimeType)) continue;
            return true;
        }
        return false;
    }

    protected void handleResponse(WeixinResponse response) throws WeixinException {
        boolean hasStreamMimeType = this.hasStreamMimeType(response);
        if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
            this.logger.debug("weixin response << " + response.getProtocol() + response.getStatus() + " << " + (hasStreamMimeType ? response.getHeaders().getContentType() : response.getAsString()));
        }
        if (hasStreamMimeType) {
            return;
        }
        ApiResult result = response.getAsResult();
        if (!SUCCESS_CODE.contains(String.format(",%s,", result.getReturnCode().toLowerCase()))) {
            throw new WeixinException(result.getReturnCode(), result.getReturnMsg());
        }
        if (XmlMessageConverter.GLOBAL.canConvert(ApiXmlResult.class, response)) {
            try {
                ApiXmlResult xmlResult = XmlMessageConverter.GLOBAL.convert(ApiXmlResult.class, response);
                if (!SUCCESS_CODE.contains(String.format(",%s,", xmlResult.getResultCode().toLowerCase()))) {
                    throw new WeixinException(xmlResult.getErrCode(), xmlResult.getErrCodeDes());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpClient getExecuteClient() {
        return this.httpClient;
    }

    public WeixinRequestClient createSSLRequestExecutor(String password, InputStream inputStream) throws WeixinException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, password.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            return this.createSSLRequestExecutor(sslContext);
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new WeixinException("Key load error", e);
        }
    }

    public WeixinRequestClient createSSLRequestExecutor(SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be empty");
        }
        HttpParams params = new HttpParams();
        params.setSSLContext(sslContext);
        return new WeixinRequestClient(params);
    }
}

