/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.request;

import cn.ipokerface.weixin.utils.IOUtils;
import cn.ipokerface.weixin.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WeixinErrorHolder {
    private static byte[] errorXmlByteArray;
    private static final Map<String, String> errorCacheMap;

    public static String getText(String code) throws RuntimeException {
        if (StringUtil.isBlank(code)) {
            return "";
        }
        String text = errorCacheMap.get(code);
        if (StringUtil.isBlank(text)) {
            ErrorTextHandler textHandler = new ErrorTextHandler(code);
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(textHandler);
                xmlReader.parse(new InputSource(new ByteArrayInputStream(errorXmlByteArray)));
                text = textHandler.getText();
                errorCacheMap.put(code, text);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                text = textHandler.getText();
                errorCacheMap.put(code, text);
            }
        }
        return text;
    }

    static {
        errorCacheMap = new ConcurrentHashMap<String, String>();
        try {
            errorXmlByteArray = IOUtils.toByteArray(WeixinErrorHolder.class.getResourceAsStream("error.xml"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ErrorTextHandler
    extends DefaultHandler {
        private final String code;
        private String text;
        private boolean codeElement;
        private boolean textElement;
        private boolean findElement;

        public ErrorTextHandler(String code) {
            this.code = code;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.codeElement = qName.equalsIgnoreCase("code");
            this.textElement = qName.equalsIgnoreCase("text");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String _text = new String(ch, start, length);
            if (this.codeElement && _text.equalsIgnoreCase(this.code)) {
                this.findElement = true;
            } else if (this.textElement && this.findElement) {
                this.text = _text;
                throw new SAXException("ENOUGH");
            }
        }

        public String getText() {
            return StringUtil.isBlank(this.text) ? "" : this.text;
        }
    }
}

