/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy.redpack;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.MapUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedPacketRisk {
    private Map<String, String> risk = new HashMap<String, String>();

    public RedPacketRisk postTimestamp() {
        this.risk.put("posttime", DateUtils.timestamp2string());
        return this;
    }

    public RedPacketRisk mobile(String mobile) {
        this.risk.put("mobile", mobile);
        return this;
    }

    public RedPacketRisk clientVersion(String clientVersion) {
        this.risk.put("clientversion", clientVersion);
        return this;
    }

    public RedPacketRisk deviceid(String deviceid) {
        this.risk.put("deviceid", deviceid);
        return this;
    }

    public Map<String, String> getRisk() {
        return this.risk;
    }

    public String toContent() {
        if (this.risk.isEmpty()) {
            return null;
        }
        try {
            return URLEncoder.encode(MapUtils.toJoinString(this.risk, false, false), Constant.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

