/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.proxy.MerchantProxy;
import cn.ipokerface.weixin.proxy.merchant.BillType;
import cn.ipokerface.weixin.proxy.merchant.CurrencyType;
import cn.ipokerface.weixin.proxy.merchant.IdQuery;
import cn.ipokerface.weixin.proxy.merchant.IdType;
import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.proxy.merchant.Order;
import cn.ipokerface.weixin.proxy.merchant.ZipType;
import cn.ipokerface.weixin.proxy.payment.AppPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.JsapiPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.MerchantPaymentPackage;
import cn.ipokerface.weixin.proxy.payment.MerchantPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.MicroPaymentRequest;
import cn.ipokerface.weixin.proxy.payment.NativePaymentRequest;
import cn.ipokerface.weixin.proxy.payment.NativePaymentResponse;
import cn.ipokerface.weixin.proxy.payment.OpenidResult;
import cn.ipokerface.weixin.proxy.payment.PrePayment;
import cn.ipokerface.weixin.proxy.payment.SceneInfoApp;
import cn.ipokerface.weixin.proxy.payment.SceneInfoStore;
import cn.ipokerface.weixin.proxy.payment.WapPaymentRequest;
import cn.ipokerface.weixin.proxy.refund.RefundAccountType;
import cn.ipokerface.weixin.proxy.refund.RefundRecord;
import cn.ipokerface.weixin.proxy.refund.RefundResult;
import cn.ipokerface.weixin.request.ApiXmlResult;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.sign.SignType;
import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.DigestUtils;
import cn.ipokerface.weixin.utils.IOUtils;
import cn.ipokerface.weixin.utils.MapUtils;
import cn.ipokerface.weixin.utils.RandomUtil;
import cn.ipokerface.weixin.utils.StringUtil;
import cn.ipokerface.weixin.xml.ListSuffixResultDeserializer;
import cn.ipokerface.weixin.xml.XmlFormatter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PaymentProxy
extends MerchantProxy {
    public PaymentProxy(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public PrePayment createPrePay(MerchantPaymentPackage payPackage) throws WeixinException {
        super.declareMerchant(payPackage);
        payPackage.setSign(this.weixinSignature.sign(payPackage));
        String payJsRequestXml = XmlFormatter.toXML(payPackage);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/unifiedorder", payJsRequestXml);
        return response.getAsObject(new TypeReference<PrePayment>(){});
    }

    public MerchantPaymentRequest createPayRequest(MerchantPaymentPackage payPackage) throws WeixinException {
        if (StringUtil.isBlank(payPackage.getTradeType())) {
            throw new WeixinException("tradeType not be empty");
        }
        String tradeType = payPackage.getTradeType().toUpperCase();
        if (TradeType.MICROPAY.name().equals(tradeType)) {
            MerchantPaymentPackage _payPackage = new MerchantPaymentPackage(payPackage.getBody(), payPackage.getDetail(), payPackage.getOutTradeNo(), DateUtils.formatFee2Yuan(payPackage.getTotalFee()), null, null, payPackage.getCreateIp(), null, null, payPackage.getAuthCode(), null, payPackage.getAttach(), null, null, payPackage.getGoodsTag(), payPackage.getLimitPay(), payPackage.getSubAppId());
            super.declareMerchant(_payPackage);
            _payPackage.setSign(this.weixinSignature.sign(_payPackage));
            String para = XmlFormatter.toXML(_payPackage);
            WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/micropay", para);
            MicroPaymentRequest microPayRequest = response.getAsObject(new TypeReference<MicroPaymentRequest>(){});
            microPayRequest.setPaymentAccount(this.weixinPayAccount);
            return microPayRequest;
        }
        PrePayment prePay = this.createPrePay(payPackage);
        if (TradeType.APP.name().equals(tradeType)) {
            return new AppPaymentRequest(prePay.getPrepayId(), this.weixinPayAccount);
        }
        if (TradeType.JSAPI.name().equals(tradeType)) {
            return new JsapiPaymentRequest(prePay.getPrepayId(), this.weixinPayAccount);
        }
        if (TradeType.NATIVE.name().equals(tradeType)) {
            return new NativePaymentRequest(prePay.getPrepayId(), prePay.getPayUrl(), this.weixinPayAccount);
        }
        if (TradeType.MWEB.name().equals(tradeType)) {
            return new WapPaymentRequest(prePay.getPrepayId(), prePay.getPayUrl(), this.weixinPayAccount);
        }
        throw new WeixinException("unknown tradeType:" + tradeType);
    }

    public MerchantPaymentRequest createJSPayRequest(String openId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.JSAPI, openId, null, null, attach);
        return this.createPayRequest(payPackage);
    }

    public String createAddressRequestJSON(String url, String oauthToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.weixinPayAccount.getId());
        map.put("timeStamp", DateUtils.timestamp2string());
        map.put("nonceStr", RandomUtil.generateString(16));
        map.put("url", url);
        map.put("accessToken", oauthToken);
        String sign = DigestUtils.SHA1(MapUtils.toJoinString(map, false, true));
        map.remove("url");
        map.remove("accessToken");
        map.put("scope", "jsapi_address");
        map.put("signType", SignType.SHA1.name().toLowerCase());
        map.put("addrSign", sign);
        return JSON.toJSONString(map);
    }

    public String createNativePayRequest(String productId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = DateUtils.timestamp2string();
        String noncestr = RandomUtil.generateString(16);
        map.put("appid", this.weixinPayAccount.getId());
        map.put("mch_id", this.weixinPayAccount.getMchId());
        map.put("time_stamp", timestamp);
        map.put("nonce_str", noncestr);
        map.put("product_id", productId);
        String sign = this.weixinSignature.sign(map);
        return String.format("weixin://wxpay/bizpayurl?sign=%s&appid=%s&mch_id=%s&product_id=%s&time_stamp=%s&nonce_str=%s", sign, this.weixinPayAccount.getId(), this.weixinPayAccount.getMchId(), productId, timestamp, noncestr);
    }

    public NativePaymentResponse createNativePayResponse(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.NATIVE, null, null, productId, attach);
        PrePayment prePay = this.createPrePay(payPackage);
        return new NativePaymentResponse(this.weixinPayAccount, prePay.getPrepayId());
    }

    public MerchantPaymentRequest createNativePayRequest(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.NATIVE, null, null, productId, attach);
        return this.createPayRequest(payPackage);
    }

    public MerchantPaymentRequest createAppPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, SceneInfoStore store) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.APP, null, null, null, attach);
        if (store != null) {
            payPackage.setSceneInfo(String.format("{\"store_id\": \"%s\", \"store_name\":\"%s\"}", store.getId(), store.getName()));
        }
        return this.createPayRequest(payPackage);
    }

    public MerchantPaymentRequest createWapPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, SceneInfoApp app) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.MWEB, null, null, null, attach);
        if (app != null) {
            payPackage.setSceneInfo(String.format("{\"h5_info\":\"%s\"}", app.getSceneInfo()));
        }
        return this.createPayRequest(payPackage);
    }

    public MerchantPaymentRequest createMicroPayRequest(String authCode, String body, String outTradeNo, double totalFee, String createIp, String attach, SceneInfoStore store) throws WeixinException {
        MerchantPaymentPackage payPackage = new MerchantPaymentPackage(body, outTradeNo, totalFee, null, createIp, TradeType.MICROPAY, null, authCode, null, attach);
        if (store != null) {
            payPackage.setSceneInfo(String.format("{\"store_info\":\"%s\"}", JSON.toJSONString((Object)store)));
        }
        return this.createPayRequest(payPackage);
    }

    public Order queryOrder(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/orderquery", param);
        return ListSuffixResultDeserializer.deserialize(response.getAsString(), Order.class);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, CurrencyType refundFeeType, String opUserId, String refundDesc, RefundAccountType refundAccountType) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("out_refund_no", outRefundNo);
        map.put("total_fee", Integer.toString(DateUtils.formatYuan2Fen(totalFee)));
        map.put("refund_fee", Integer.toString(DateUtils.formatYuan2Fen(refundFee)));
        if (StringUtil.isBlank(opUserId)) {
            opUserId = this.weixinPayAccount.getMchId();
        }
        map.put("op_user_id", opUserId);
        if (refundFeeType == null) {
            refundFeeType = CurrencyType.CNY;
        }
        if (refundAccountType == null) {
            refundAccountType = RefundAccountType.REFUND_SOURCE_UNSETTLED_FUNDS;
        }
        if (StringUtil.isNotBlank(refundDesc)) {
            map.put("refund_desc", refundDesc);
        }
        map.put("refund_fee_type", refundFeeType.name());
        map.put("refund_account", refundAccountType.name());
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.com/secapi/pay/refund", param);
        return response.getAsObject(new TypeReference<RefundResult>(){});
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee) throws WeixinException {
        return this.applyRefund(idQuery, outRefundNo, totalFee, totalFee, null, null, null, null);
    }

    public MerchantResult reverseOrder(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.com/secapi/pay/reverse", param);
        return response.getAsObject(new TypeReference<MerchantResult>(){});
    }

    public String getShorturl(String url) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        try {
            map.put("long_url", URLEncoder.encode(url, Constant.UTF_8.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/tools/shorturl", param);
        map = XmlFormatter.xml2map(response.getAsString());
        return map.get("short_url");
    }

    public MerchantResult closeOrder(String outTradeNo) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(new IdQuery(outTradeNo, IdType.TRADENO));
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/closeorder", param);
        return response.getAsObject(new TypeReference<MerchantResult>(){});
    }

    public void downloadBill(Date billDate, BillType billType, OutputStream outputStream, ZipType tarType) throws WeixinException {
        if (billDate == null) {
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            billDate = now.getTime();
        }
        if (billType == null) {
            billType = BillType.ALL;
        }
        String formatBillDate = DateUtils.fortmat2yyyyMMdd(billDate);
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("bill_date", formatBillDate);
        map.put("bill_type", billType.name());
        if (tarType != null) {
            map.put("tar_type", tarType.name());
        }
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/downloadbill", param);
        if (ZipType.GZIP == tarType) {
            try {
                IOUtils.copy(response.getBody(), outputStream);
            }
            catch (IOException iOException) {}
        } else {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(outputStream, Constant.UTF_8));
                reader = new BufferedReader(new InputStreamReader(response.getBody(), Constant.UTF_8));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new WeixinException(e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public RefundRecord queryRefund(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/pay/refundquery", param);
        return ListSuffixResultDeserializer.deserialize(response.getAsString(), RefundRecord.class);
    }

    public ApiXmlResult reportInterface(String interfaceUrl, int executeTime, String outTradeNo, String ip, Date time, ApiXmlResult returnXml) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("interface_url", interfaceUrl);
        map.put("execute_time_", Integer.toString(executeTime));
        map.put("out_trade_no", outTradeNo);
        map.put("user_ip", ip);
        map.put("time", DateUtils.fortmat2yyyyMMddHHmmss(time));
        map.putAll((Map)JSON.toJSON((Object)returnXml));
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/payitil/report", param);
        return response.getAsXml();
    }

    public OpenidResult authCode2openId(String authCode) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("auth_code", authCode);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/tools/authcodetoopenid", param);
        return response.getAsObject(new TypeReference<OpenidResult>(){});
    }
}

