/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.proxy.MerchantProxy;
import cn.ipokerface.weixin.proxy.coupon.CouponDetail;
import cn.ipokerface.weixin.proxy.coupon.CouponResult;
import cn.ipokerface.weixin.proxy.coupon.CouponStock;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.utils.StringUtil;
import cn.ipokerface.weixin.xml.XmlFormatter;
import com.alibaba.fastjson.TypeReference;
import java.util.Map;

public class CouponProxy
extends MerchantProxy {
    public CouponProxy(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public CouponResult sendCoupon(String couponStockId, String partnerTradeNo, String openId, String opUserId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("coupon_stock_id", couponStockId);
        map.put("partner_trade_no", partnerTradeNo);
        map.put("openid", openId);
        map.put("openid_count", "1");
        if (StringUtil.isBlank(opUserId)) {
            opUserId = this.weixinPayAccount.getMchId();
        }
        map.put("op_user_id", opUserId);
        map.put("version", "1.0");
        map.put("type", "XML");
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.getWeixinSSLExecutor().post("https://api.mch.weixin.qq.commmpaymkttransfers/send_coupon", param);
        return response.getAsObject(new TypeReference<CouponResult>(){});
    }

    public CouponStock queryCouponStock(String couponStockId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("coupon_stock_id", couponStockId);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/mmpaymkttransfers/query_coupon_stock", param);
        return response.getAsObject(new TypeReference<CouponStock>(){});
    }

    public CouponDetail queryCouponDetail(String openId, String couponId, String stockId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("openid", openId);
        map.put("coupon_id", couponId);
        map.put("stock_id", stockId);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlFormatter.map2xml(map);
        WeixinResponse response = this.weixinRequestClient.post("https://api.mch.weixin.qq.com/mmpaymkttransfers/querycouponsinfo", param);
        return response.getAsObject(new TypeReference<CouponDetail>(){});
    }
}

