/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.card;

import cn.ipokerface.weixin.model.card.CardCoupon;
import cn.ipokerface.weixin.model.card.CardType;
import cn.ipokerface.weixin.model.card.CouponBase;
import cn.ipokerface.weixin.model.card.FieldNameType;
import cn.ipokerface.weixin.model.card.MemberCardBonusRule;
import cn.ipokerface.weixin.model.card.MemberCardCustomField;
import com.alibaba.fastjson.annotation.JSONField;

public class MemberCard
extends CardCoupon {
    @JSONField(name="background_pic_url")
    private String backgroundPicUrl;
    @JSONField(name="prerogative")
    private String prerogative;
    @JSONField(name="auto_activate")
    private boolean autoActivate;
    @JSONField(name="wx_activate")
    private boolean wxActivate;
    @JSONField(name="activate_url")
    private String activateUrl;
    @JSONField(name="supply_bonus")
    private boolean supplyBonus;
    @JSONField(name="bonus_url")
    private String bonusUrl;
    @JSONField(name="supply_balance")
    private boolean supplyBalance;
    @JSONField(name="balance_url")
    private String balanceUrl;
    @JSONField(name="custom_field1")
    private MemberCardCustomField customField1;
    @JSONField(name="custom_field2")
    private MemberCardCustomField customField2;
    @JSONField(name="custom_field3")
    private MemberCardCustomField customField3;
    @JSONField(name="bonus_rules")
    private String bonusRules;
    @JSONField(name="balance_rules")
    private String balanceRules;
    @JSONField(name="bonus_cleared")
    private String bonusCleared;
    @JSONField(name="custom_cell1")
    private MemberCardCustomField customCell1;
    private int discount;
    @JSONField(name="bonus_rule")
    private MemberCardBonusRule bonusRule;

    protected MemberCard(CouponBase couponBaseInfo, Builder builder) {
        super(couponBaseInfo);
        this.activateUrl = builder.activateUrl;
        this.backgroundPicUrl = builder.backgroundPicUrl;
        this.prerogative = builder.prerogative;
        this.autoActivate = builder.autoActivate;
        this.wxActivate = builder.wxActivate;
        this.activateUrl = builder.activateUrl;
        this.supplyBonus = builder.supplyBonus;
        this.bonusUrl = builder.bonusUrl;
        this.supplyBalance = builder.supplyBalance;
        this.balanceUrl = builder.balanceUrl;
        this.customField1 = builder.customField1;
        this.customField2 = builder.customField2;
        this.customField3 = builder.customField3;
        this.bonusRules = builder.bonusRules;
        this.balanceRules = builder.balanceRules;
        this.bonusCleared = builder.bonusCleared;
        this.customCell1 = builder.customCell1;
        this.discount = builder.discount;
        this.bonusRule = builder.bonusRule;
    }

    @JSONField(serialize=false)
    public CardType getCardType() {
        return CardType.MEMBER_CARD;
    }

    public String getBackgroundPicUrl() {
        return this.backgroundPicUrl;
    }

    public String getPrerogative() {
        return this.prerogative;
    }

    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    public boolean isWxActivate() {
        return this.wxActivate;
    }

    public String getActivateUrl() {
        return this.activateUrl;
    }

    public boolean isSupplyBonus() {
        return this.supplyBonus;
    }

    public String getBonusUrl() {
        return this.bonusUrl;
    }

    public boolean getSupplyBalance() {
        return this.supplyBalance;
    }

    public String getBalanceUrl() {
        return this.balanceUrl;
    }

    public MemberCardCustomField getCustomField1() {
        return this.customField1;
    }

    public MemberCardCustomField getCustomField2() {
        return this.customField2;
    }

    public MemberCardCustomField getCustomField3() {
        return this.customField3;
    }

    public String getBonusRules() {
        return this.bonusRules;
    }

    public String getBalanceRules() {
        return this.balanceRules;
    }

    public String getBonusCleared() {
        return this.bonusCleared;
    }

    public MemberCardCustomField getCustomCell1() {
        return this.customCell1;
    }

    public int getDiscount() {
        return this.discount;
    }

    public MemberCardBonusRule getBonusRule() {
        return this.bonusRule;
    }

    public static final class Builder {
        private String backgroundPicUrl;
        private String prerogative;
        private boolean autoActivate;
        private boolean wxActivate;
        private String activateUrl;
        private boolean supplyBonus;
        private String bonusUrl;
        private boolean supplyBalance;
        private String balanceUrl;
        private MemberCardCustomField customField1;
        private MemberCardCustomField customField2;
        private MemberCardCustomField customField3;
        private String bonusRules;
        private String balanceRules;
        private String bonusCleared;
        private MemberCardCustomField customCell1;
        private int discount;
        private MemberCardBonusRule bonusRule;

        public Builder backgroundPicUrl(String backgroundPicUrl) {
            this.backgroundPicUrl = backgroundPicUrl;
            return this;
        }

        public Builder prerogative(String prerogative) {
            this.prerogative = prerogative;
            return this;
        }

        public Builder activateWithAuto(boolean autoActivate) {
            this.autoActivate = autoActivate;
            this.activateUrl = null;
            this.wxActivate = false;
            return this;
        }

        public Builder activateWithWx(boolean wxActivate) {
            this.wxActivate = wxActivate;
            this.autoActivate = false;
            this.activateUrl = null;
            return this;
        }

        public Builder activateUrl(String activateUrl) {
            this.activateUrl = activateUrl;
            this.autoActivate = false;
            this.wxActivate = false;
            return this;
        }

        public Builder supplyBonus(boolean supplyBonus) {
            this.supplyBonus = supplyBonus;
            return this;
        }

        public Builder bonusUrl(String bonusUrl) {
            this.bonusUrl = bonusUrl;
            return this;
        }

        public Builder supplyBalance(boolean supplyBalance) {
            this.supplyBalance = supplyBalance;
            return this;
        }

        public Builder balanceUrl(String balanceUrl) {
            this.balanceUrl = balanceUrl;
            return this;
        }

        public Builder customField1(FieldNameType type, String name, String url) {
            this.customField1 = new MemberCardCustomField(type, name, url);
            return this;
        }

        public Builder customField2(FieldNameType type, String name, String url) {
            this.customField2 = new MemberCardCustomField(type, name, url);
            return this;
        }

        public Builder customField3(FieldNameType type, String name, String url) {
            this.customField3 = new MemberCardCustomField(type, name, url);
            return this;
        }

        public Builder bonusRules(String bonusRules) {
            this.bonusRules = bonusRules;
            return this;
        }

        public Builder balanceRules(String balanceRules) {
            this.balanceRules = balanceRules;
            return this;
        }

        public Builder bonusCleared(String bonusCleared) {
            this.bonusCleared = bonusCleared;
            return this;
        }

        public Builder customCell1(String name, String url, String tips) {
            this.customCell1 = new MemberCardCustomField(name, url, tips);
            return this;
        }

        public Builder discount(int discount) {
            this.discount = discount;
            return this;
        }

        public Builder bonusRule(MemberCardBonusRule bonusRule) {
            this.bonusRule = bonusRule;
            return this;
        }
    }
}

