/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.card;

import cn.ipokerface.weixin.model.card.CardCoupon;
import cn.ipokerface.weixin.model.card.CardType;
import cn.ipokerface.weixin.model.card.CouponBase;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;

public class CashCoupon
extends CardCoupon {
    @JSONField(name="least_cost")
    private int leastCost;
    @JSONField(name="reduce_cost")
    private final int reduceCost;

    public CashCoupon(CouponBase couponBaseInfo, double reduceCost) {
        super(couponBaseInfo);
        this.reduceCost = DateUtils.formatYuan2Fen(reduceCost);
    }

    public int getLeastCost() {
        return this.leastCost;
    }

    @JSONField(serialize=false)
    public double getFormatLeastCost() {
        return (double)this.leastCost / 100.0;
    }

    public void setLeastCost(double leastCost) {
        this.leastCost = DateUtils.formatYuan2Fen(this.reduceCost);
    }

    public int getReduceCost() {
        return this.reduceCost;
    }

    @JSONField(serialize=false)
    public double getFormatReduceCost() {
        return (double)this.reduceCost / 100.0;
    }

    @JSONField(serialize=false)
    public CardType getCardType() {
        return CardType.CASH;
    }

    public String toString() {
        return "CashCoupon [leastCost=" + this.leastCost + ", reduceCost=" + this.reduceCost + ", " + super.toString() + "]";
    }
}

