/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model;

import cn.ipokerface.weixin.cache.Cacheable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements Cacheable {
    private static final long serialVersionUID = -7564855472419104084L;
    private String accessToken;
    private long expires;
    private long createTime;
    private Map<String, String> extra;

    public Token(String accessToken) {
        this(accessToken, -1L);
    }

    public Token(String accessToken, long expires) {
        this(accessToken, expires, System.currentTimeMillis());
    }

    public Token(String accessToken, long expires, long createTime) {
        this.accessToken = accessToken;
        this.expires = expires;
        this.createTime = createTime;
        this.extra = new HashMap<String, String>();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public long expiredTime() {
        return this.expires;
    }

    @Override
    public long createTime() {
        return this.createTime;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public Token pushExtra(String name, String value) {
        this.extra.put(name, value);
        return this;
    }

    public String toString() {
        return "Token [accessToken=" + this.accessToken + ", expires=" + this.expires + ", createTime=" + this.createTime + ", extra=" + this.extra + "]";
    }
}

