/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.jssdk;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.jssdk.JssdkApis;
import cn.ipokerface.weixin.token.TokenManager;
import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.DigestUtils;
import cn.ipokerface.weixin.utils.MapUtils;
import cn.ipokerface.weixin.utils.RandomUtil;
import cn.ipokerface.weixin.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JssdkConfigurator {
    private final TokenManager ticketTokenManager;
    private JSONObject config;
    private Set<JssdkApis> apis;

    public JssdkConfigurator(TokenManager ticketTokenManager) {
        this.ticketTokenManager = ticketTokenManager;
        this.config = new JSONObject();
        this.apis = new HashSet<JssdkApis>();
    }

    public JssdkConfigurator debugMode() {
        this.config.put("debug", (Object)true);
        return this;
    }

    public JssdkConfigurator apis(JssdkApis ... apis) {
        for (JssdkApis api : apis) {
            this.apis.add(api);
        }
        return this;
    }

    public JssdkConfigurator apis(JssdkApis[] ... apis) {
        for (JssdkApis[] api : apis) {
            this.apis(api);
        }
        return this;
    }

    public String toJSONConfig(String url) throws WeixinException {
        if (this.apis.isEmpty()) {
            throw new WeixinException("jsapilist not be empty");
        }
        HashMap<String, String> signMap = new HashMap<String, String>();
        String timestamp = DateUtils.timestamp2string();
        String noncestr = RandomUtil.generateString(24);
        signMap.put("timestamp", timestamp);
        signMap.put("noncestr", noncestr);
        signMap.put("jsapi_ticket", this.ticketTokenManager.getAccessToken());
        signMap.put("url", url);
        String sign = DigestUtils.SHA1(MapUtils.toJoinString(signMap, false, false));
        this.config.put("appId", (Object)this.ticketTokenManager.getWeixinId());
        if (StringUtil.isBlank(this.config.getString("debug"))) {
            this.config.put("debug", (Object)false);
        }
        this.config.put("timestamp", (Object)timestamp);
        this.config.put("nonceStr", (Object)noncestr);
        this.config.put("signature", (Object)sign);
        this.config.put("jsApiList", (Object)this.apis.toArray());
        return this.config.toJSONString();
    }
}

